/*
 * Decompiled with CFR 0.152.
 */
package com.sipios.springsearch.configuration;

import com.sipios.springsearch.SpecificationsBuilder;
import com.sipios.springsearch.anotation.SearchSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J4\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/sipios/springsearch/configuration/SearchSpecificationResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "()V", "buildSpecification", "Lorg/springframework/data/jpa/domain/Specification;", "T", "specClass", "Ljava/lang/Class;", "search", "", "resolveArgument", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "supportsParameter", "", "Companion", "spring-search"})
public final class SearchSpecificationResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger;
    public static final Companion Companion;

    public boolean supportsParameter(@NonNull @NotNull MethodParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return parameter.getParameterType() == Specification.class && parameter.hasParameterAnnotation(SearchSpec.class);
    }

    @Nullable
    public Specification<?> resolveArgument(@NonNull @NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)webRequest, (String)"webRequest");
        SearchSpec def = (SearchSpec)parameter.getParameterAnnotation(SearchSpec.class);
        Class<?> clazz = parameter.getGenericParameterType().getClass();
        SearchSpec searchSpec = def;
        if (searchSpec == null) {
            Intrinsics.throwNpe();
        }
        return this.buildSpecification(clazz, webRequest.getParameter(searchSpec.searchParam()));
    }

    private final <T> Specification<T> buildSpecification(Class<T> specClass, String search) {
        CharSequence charSequence;
        logger.debug("Building specification for class {}", specClass);
        logger.debug("Search value found is {}", (Object)search);
        if (search == null || (charSequence = (CharSequence)search).length() == 0) {
            return null;
        }
        SpecificationsBuilder specBuilder = new SpecificationsBuilder();
        return specBuilder.withSearch(search).build();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(SearchSpecificationResolver.class);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sipios/springsearch/configuration/SearchSpecificationResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "spring-search"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

