/*
 * Decompiled with CFR 0.152.
 */
package com.sipios.springsearch;

import com.sipios.springsearch.SearchCriteria;
import com.sipios.springsearch.anotation.SearchSpec;
import com.sipios.springsearch.strategies.ParsingStrategy;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/sipios/springsearch/SpecificationImpl;", "T", "Lorg/springframework/data/jpa/domain/Specification;", "criteria", "Lcom/sipios/springsearch/SearchCriteria;", "searchSpecAnnotation", "Lcom/sipios/springsearch/anotation/SearchSpec;", "(Lcom/sipios/springsearch/SearchCriteria;Lcom/sipios/springsearch/anotation/SearchSpec;)V", "getNestedRoot", "Ljavax/persistence/criteria/Path;", "root", "Ljavax/persistence/criteria/Root;", "nestedKey", "", "", "toPredicate", "Ljavax/persistence/criteria/Predicate;", "query", "Ljavax/persistence/criteria/CriteriaQuery;", "builder", "Ljavax/persistence/criteria/CriteriaBuilder;", "spring-search"})
public final class SpecificationImpl<T>
implements Specification<T> {
    private final SearchCriteria criteria;
    private final SearchSpec searchSpecAnnotation;

    @Nullable
    public Predicate toPredicate(@NotNull Root<T> root, @NotNull CriteriaQuery<?> query, @NotNull CriteriaBuilder builder) throws ResponseStatusException {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List nestedKey = StringsKt.split$default((CharSequence)this.criteria.getKey(), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        Path<?> nestedRoot = this.getNestedRoot(root, nestedKey);
        String criteriaKey = (String)nestedKey.get(nestedKey.size() - 1);
        Path path = nestedRoot.get(criteriaKey);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"nestedRoot.get<Any>(criteriaKey)");
        Class clazz = path.getJavaType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"nestedRoot.get<Any>(criteriaKey).javaType");
        KClass fieldClass = JvmClassMappingKt.getKotlinClass((Class)clazz);
        ParsingStrategy strategy = ParsingStrategy.Companion.getStrategy((KClass<? extends Object>)fieldClass, this.searchSpecAnnotation);
        Object value = null;
        try {
            value = strategy.parse(this.criteria.getValue(), (KClass<? extends Object>)fieldClass);
        }
        catch (Exception e) {
            throw (Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST, "Could not parse input for the field " + criteriaKey + " as a " + fieldClass.getSimpleName());
        }
        return strategy.buildPredicate(builder, nestedRoot, criteriaKey, this.criteria.getOperation(), value);
    }

    private final Path<?> getNestedRoot(Root<T> root, List<String> nestedKey) {
        ArrayList prefix = new ArrayList(nestedKey);
        prefix.remove(nestedKey.size() - 1);
        Path temp = (Path)root;
        for (String s : prefix) {
            Intrinsics.checkNotNullExpressionValue((Object)temp.get(s), (String)"temp.get<T>(s)");
        }
        return temp;
    }

    public SpecificationImpl(@NotNull SearchCriteria criteria, @NotNull SearchSpec searchSpecAnnotation) {
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter((Object)searchSpecAnnotation, (String)"searchSpecAnnotation");
        this.criteria = criteria;
        this.searchSpecAnnotation = searchSpecAnnotation;
    }
}

