/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.cells;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class CellGestures {
    static final double handleRadius = 6.0;
    static DragNodeSupplier NORTH = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty widthProperty = region.prefWidthProperty();
            DoubleBinding halfWidthProperty = widthProperty.divide(2);
            Rectangle resizeHandleN = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleN.xProperty().bind((ObservableValue)xProperty.add((ObservableNumberValue)halfWidthProperty).subtract(3.0));
            resizeHandleN.yProperty().bind((ObservableValue)yProperty.subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleN, mouseLocation, Cursor.N_RESIZE);
            resizeHandleN.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragNorth(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleN;
        }
    };
    static DragNodeSupplier NORTH_EAST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty widthProperty = region.prefWidthProperty();
            Rectangle resizeHandleNE = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleNE.xProperty().bind((ObservableValue)xProperty.add((ObservableNumberValue)widthProperty).subtract(3.0));
            resizeHandleNE.yProperty().bind((ObservableValue)yProperty.subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleNE, mouseLocation, Cursor.NE_RESIZE);
            resizeHandleNE.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragNorth(event, mouseLocation, region, 6.0);
                    CellGestures.dragEast(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleNE;
        }
    };
    static DragNodeSupplier EAST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty widthProperty = region.prefWidthProperty();
            DoubleProperty heightProperty = region.prefHeightProperty();
            DoubleBinding halfHeightProperty = heightProperty.divide(2);
            Rectangle resizeHandleE = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleE.xProperty().bind((ObservableValue)xProperty.add((ObservableNumberValue)widthProperty).subtract(3.0));
            resizeHandleE.yProperty().bind((ObservableValue)yProperty.add((ObservableNumberValue)halfHeightProperty).subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleE, mouseLocation, Cursor.E_RESIZE);
            resizeHandleE.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragEast(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleE;
        }
    };
    static DragNodeSupplier SOUTH_EAST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty widthProperty = region.prefWidthProperty();
            DoubleProperty heightProperty = region.prefHeightProperty();
            Rectangle resizeHandleSE = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleSE.xProperty().bind((ObservableValue)xProperty.add((ObservableNumberValue)widthProperty).subtract(3.0));
            resizeHandleSE.yProperty().bind((ObservableValue)yProperty.add((ObservableNumberValue)heightProperty).subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleSE, mouseLocation, Cursor.SE_RESIZE);
            resizeHandleSE.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragSouth(event, mouseLocation, region, 6.0);
                    CellGestures.dragEast(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleSE;
        }
    };
    static DragNodeSupplier SOUTH = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty widthProperty = region.prefWidthProperty();
            DoubleBinding halfWidthProperty = widthProperty.divide(2);
            DoubleProperty heightProperty = region.prefHeightProperty();
            Rectangle resizeHandleS = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleS.xProperty().bind((ObservableValue)xProperty.add((ObservableNumberValue)halfWidthProperty).subtract(3.0));
            resizeHandleS.yProperty().bind((ObservableValue)yProperty.add((ObservableNumberValue)heightProperty).subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleS, mouseLocation, Cursor.S_RESIZE);
            resizeHandleS.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragSouth(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleS;
        }
    };
    static DragNodeSupplier SOUTH_WEST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty heightProperty = region.prefHeightProperty();
            Rectangle resizeHandleSW = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleSW.xProperty().bind((ObservableValue)xProperty.subtract(3.0));
            resizeHandleSW.yProperty().bind((ObservableValue)yProperty.add((ObservableNumberValue)heightProperty).subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleSW, mouseLocation, Cursor.SW_RESIZE);
            resizeHandleSW.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragSouth(event, mouseLocation, region, 6.0);
                    CellGestures.dragWest(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleSW;
        }
    };
    static DragNodeSupplier WEST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            DoubleProperty heightProperty = region.prefHeightProperty();
            DoubleBinding halfHeightProperty = heightProperty.divide(2);
            Rectangle resizeHandleW = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleW.xProperty().bind((ObservableValue)xProperty.subtract(3.0));
            resizeHandleW.yProperty().bind((ObservableValue)yProperty.add((ObservableNumberValue)halfHeightProperty).subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleW, mouseLocation, Cursor.W_RESIZE);
            resizeHandleW.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragWest(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleW;
        }
    };
    static DragNodeSupplier NORTH_WEST = new DragNodeSupplier(){

        @Override
        public Node apply(Region region, Wrapper<Point2D> mouseLocation) {
            DoubleProperty xProperty = region.layoutXProperty();
            DoubleProperty yProperty = region.layoutYProperty();
            Rectangle resizeHandleNW = new Rectangle(6.0, 6.0, (Paint)Color.BLACK);
            resizeHandleNW.xProperty().bind((ObservableValue)xProperty.subtract(3.0));
            resizeHandleNW.yProperty().bind((ObservableValue)yProperty.subtract(3.0));
            CellGestures.setUpDragging((Node)resizeHandleNW, mouseLocation, Cursor.NW_RESIZE);
            resizeHandleNW.setOnMouseDragged(event -> {
                if (mouseLocation.value != null) {
                    CellGestures.dragNorth(event, mouseLocation, region, 6.0);
                    CellGestures.dragWest(event, mouseLocation, region, 6.0);
                    mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
                }
            });
            return resizeHandleNW;
        }
    };

    public static void makeResizable(Region region) {
        CellGestures.makeResizable(region, NORTH, NORTH_EAST, EAST, SOUTH_EAST, SOUTH, SOUTH_WEST, WEST, NORTH_WEST);
    }

    public static void makeResizable(Region region, DragNodeSupplier ... nodeSuppliers) {
        Wrapper mouseLocation = new Wrapper();
        List dragNodes = Arrays.stream(nodeSuppliers).map(supplier -> supplier.apply(region, mouseLocation)).collect(Collectors.toList());
        region.parentProperty().addListener((obs, oldParent, newParent) -> {
            for (Node c : dragNodes) {
                Pane currentParent = (Pane)c.getParent();
                if (currentParent != null) {
                    currentParent.getChildren().remove((Object)c);
                }
                ((Pane)newParent).getChildren().add((Object)c);
            }
        });
    }

    private static void dragNorth(MouseEvent event, Wrapper<Point2D> mouseLocation, Region region, double handleRadius) {
        double deltaY = event.getSceneY() - ((Point2D)mouseLocation.value).getY();
        double newY = region.getLayoutY() + deltaY;
        if (newY != 0.0 && newY >= handleRadius && newY <= region.getLayoutY() + region.getHeight() - handleRadius) {
            region.setLayoutY(newY);
            region.setPrefHeight(region.getPrefHeight() - deltaY);
        }
    }

    private static void dragEast(MouseEvent event, Wrapper<Point2D> mouseLocation, Region region, double handleRadius) {
        double deltaX = event.getSceneX() - ((Point2D)mouseLocation.value).getX();
        double newMaxX = region.getLayoutX() + region.getWidth() + deltaX;
        if (newMaxX >= region.getLayoutX() && newMaxX <= region.getParent().getBoundsInLocal().getWidth() - handleRadius) {
            region.setPrefWidth(region.getPrefWidth() + deltaX);
        }
    }

    private static void dragSouth(MouseEvent event, Wrapper<Point2D> mouseLocation, Region region, double handleRadius) {
        double deltaY = event.getSceneY() - ((Point2D)mouseLocation.value).getY();
        double newMaxY = region.getLayoutY() + region.getHeight() + deltaY;
        if (newMaxY >= region.getLayoutY() && newMaxY <= region.getParent().getBoundsInLocal().getHeight() - handleRadius) {
            region.setPrefHeight(region.getPrefHeight() + deltaY);
        }
    }

    private static void dragWest(MouseEvent event, Wrapper<Point2D> mouseLocation, Region region, double handleRadius) {
        double deltaX = event.getSceneX() - ((Point2D)mouseLocation.value).getX();
        double newX = region.getLayoutX() + deltaX;
        if (newX != 0.0 && newX <= region.getParent().getBoundsInLocal().getWidth() - handleRadius) {
            region.setLayoutX(newX);
            region.setPrefWidth(region.getPrefWidth() - deltaX);
        }
    }

    private static void setUpDragging(Node node, Wrapper<Point2D> mouseLocation, Cursor hoverCursor) {
        node.setOnMouseEntered(event -> node.getParent().setCursor(hoverCursor));
        node.setOnMouseExited(event -> node.getParent().setCursor(Cursor.DEFAULT));
        node.setOnDragDetected(event -> {
            node.getParent().setCursor(Cursor.CLOSED_HAND);
            mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
        });
        node.setOnMouseReleased(event -> {
            node.getParent().setCursor(Cursor.DEFAULT);
            mouseLocation.value = null;
        });
    }

    static interface DragNodeSupplier {
        public Node apply(Region var1, Wrapper<Point2D> var2);
    }

    static class Wrapper<T> {
        T value;

        Wrapper() {
        }
    }
}

