/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.edges;

import com.fxgraph.edges.AbstractEdge;
import com.fxgraph.graph.Graph;
import com.fxgraph.graph.ICell;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;

public class CorneredEdge
extends AbstractEdge {
    private final StringProperty textProperty;
    private final Orientation orientation;

    public CorneredEdge(ICell source, ICell target, Orientation orientation) {
        super(source, target);
        this.orientation = orientation;
        this.textProperty = new SimpleStringProperty();
    }

    public EdgeGraphic getGraphic(Graph graph) {
        return new EdgeGraphic(graph, this, this.orientation, this.textProperty);
    }

    public StringProperty textProperty() {
        return this.textProperty;
    }

    public static class EdgeGraphic
    extends Pane {
        private final Group group;
        private final Text text;

        public EdgeGraphic(Graph graph, CorneredEdge edge, Orientation orientation, StringProperty textProperty) {
            DoubleBinding sourceX = edge.getSource().getXAnchor(graph, edge);
            DoubleBinding sourceY = edge.getSource().getYAnchor(graph, edge);
            DoubleBinding targetX = edge.getTarget().getXAnchor(graph, edge);
            DoubleBinding targetY = edge.getTarget().getYAnchor(graph, edge);
            this.text = new Text();
            this.text.textProperty().bind((ObservableValue)textProperty);
            this.text.getStyleClass().add((Object)"edge-text");
            SimpleDoubleProperty textWidth = new SimpleDoubleProperty();
            SimpleDoubleProperty textHeight = new SimpleDoubleProperty();
            Runnable recalculateWidth = () -> this.lambda$new$0((DoubleProperty)textWidth, (DoubleProperty)textHeight);
            this.text.parentProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            this.text.textProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            if (orientation == Orientation.HORIZONTAL) {
                this.group = new Group();
                Line lineA = new Line();
                lineA.startXProperty().bind((ObservableValue)sourceX);
                lineA.startYProperty().bind((ObservableValue)sourceY);
                lineA.endXProperty().bind((ObservableValue)targetX);
                lineA.endYProperty().bind((ObservableValue)sourceY);
                this.group.getChildren().add((Object)lineA);
                Line lineB = new Line();
                lineB.startXProperty().bind((ObservableValue)targetX);
                lineB.startYProperty().bind((ObservableValue)sourceY);
                lineB.endXProperty().bind((ObservableValue)targetX);
                lineB.endYProperty().bind((ObservableValue)targetY);
                this.group.getChildren().add((Object)lineB);
                this.text.xProperty().bind((ObservableValue)targetX.subtract((ObservableNumberValue)textWidth.divide(2)));
                this.text.yProperty().bind((ObservableValue)sourceY.subtract((ObservableNumberValue)textHeight.divide(2)));
            } else {
                this.group = new Group();
                Line lineA = new Line();
                lineA.startXProperty().bind((ObservableValue)sourceX);
                lineA.startYProperty().bind((ObservableValue)sourceY);
                lineA.endXProperty().bind((ObservableValue)sourceX);
                lineA.endYProperty().bind((ObservableValue)targetY);
                this.group.getChildren().add((Object)lineA);
                Line lineB = new Line();
                lineB.startXProperty().bind((ObservableValue)sourceX);
                lineB.startYProperty().bind((ObservableValue)targetY);
                lineB.endXProperty().bind((ObservableValue)targetX);
                lineB.endYProperty().bind((ObservableValue)targetY);
                this.group.getChildren().add((Object)lineB);
                this.text.xProperty().bind((ObservableValue)sourceX.subtract((ObservableNumberValue)textWidth.divide(2)));
                this.text.yProperty().bind((ObservableValue)targetY.subtract((ObservableNumberValue)textHeight.divide(2)));
            }
            this.group.getChildren().add((Object)this.text);
            this.getChildren().add((Object)this.group);
        }

        public Group getGroup() {
            return this.group;
        }

        public Text getText() {
            return this.text;
        }

        private /* synthetic */ void lambda$new$0(DoubleProperty textWidth, DoubleProperty textHeight) {
            textWidth.set(this.text.getLayoutBounds().getWidth());
            textHeight.set(this.text.getLayoutBounds().getHeight());
        }
    }
}

