/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.edges;

import com.fxgraph.edges.AbstractEdge;
import com.fxgraph.graph.Graph;
import com.fxgraph.graph.ICell;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;

public class DoubleCorneredEdge
extends AbstractEdge {
    private final StringProperty textProperty;
    private final Orientation orientation;

    public DoubleCorneredEdge(ICell source, ICell target, Orientation orientation) {
        super(source, target);
        this.orientation = orientation;
        this.textProperty = new SimpleStringProperty();
    }

    public EdgeGraphic getGraphic(Graph graph) {
        return new EdgeGraphic(graph, this, this.orientation, this.textProperty);
    }

    public StringProperty textProperty() {
        return this.textProperty;
    }

    public static class EdgeGraphic
    extends Pane {
        private final DoubleBinding sourceX;
        private final DoubleBinding sourceY;
        private final DoubleBinding targetX;
        private final DoubleBinding targetY;
        private final DoubleBinding centerX;
        private final DoubleBinding centerY;
        private final Group group;
        private final Line lineA;
        private final Line lineB;
        private final Line lineC;
        private final Text text;

        public EdgeGraphic(Graph graph, DoubleCorneredEdge edge, Orientation orientation, StringProperty textProperty) {
            this.sourceX = edge.getSource().getXAnchor(graph, edge);
            this.sourceY = edge.getSource().getYAnchor(graph, edge);
            this.targetX = edge.getTarget().getXAnchor(graph, edge);
            this.targetY = edge.getTarget().getYAnchor(graph, edge);
            this.centerX = this.sourceX.add((ObservableNumberValue)this.targetX).divide(2);
            this.centerY = this.sourceY.add((ObservableNumberValue)this.targetY).divide(2);
            this.text = new Text();
            this.text.textProperty().bind((ObservableValue)textProperty);
            this.text.getStyleClass().add((Object)"edge-text");
            SimpleDoubleProperty textWidth = new SimpleDoubleProperty();
            SimpleDoubleProperty textHeight = new SimpleDoubleProperty();
            Runnable recalculateWidth = () -> this.lambda$new$0((DoubleProperty)textWidth, (DoubleProperty)textHeight);
            this.text.parentProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            this.text.textProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            if (orientation == Orientation.HORIZONTAL) {
                this.group = new Group();
                this.lineA = new Line();
                this.lineA.startXProperty().bind((ObservableValue)this.sourceX);
                this.lineA.startYProperty().bind((ObservableValue)this.sourceY);
                this.lineA.endXProperty().bind((ObservableValue)this.centerX);
                this.lineA.endYProperty().bind((ObservableValue)this.sourceY);
                this.group.getChildren().add((Object)this.lineA);
                this.lineB = new Line();
                this.lineB.startXProperty().bind((ObservableValue)this.centerX);
                this.lineB.startYProperty().bind((ObservableValue)this.sourceY);
                this.lineB.endXProperty().bind((ObservableValue)this.centerX);
                this.lineB.endYProperty().bind((ObservableValue)this.targetY);
                this.group.getChildren().add((Object)this.lineB);
                this.lineC = new Line();
                this.lineC.startXProperty().bind((ObservableValue)this.centerX);
                this.lineC.startYProperty().bind((ObservableValue)this.targetY);
                this.lineC.endXProperty().bind((ObservableValue)this.targetX);
                this.lineC.endYProperty().bind((ObservableValue)this.targetY);
                this.group.getChildren().add((Object)this.lineC);
            } else {
                this.group = new Group();
                this.lineA = new Line();
                this.lineA.startXProperty().bind((ObservableValue)this.sourceX);
                this.lineA.startYProperty().bind((ObservableValue)this.sourceY);
                this.lineA.endXProperty().bind((ObservableValue)this.sourceX);
                this.lineA.endYProperty().bind((ObservableValue)this.centerY);
                this.group.getChildren().add((Object)this.lineA);
                this.lineB = new Line();
                this.lineB.startXProperty().bind((ObservableValue)this.sourceX);
                this.lineB.startYProperty().bind((ObservableValue)this.centerY);
                this.lineB.endXProperty().bind((ObservableValue)this.targetX);
                this.lineB.endYProperty().bind((ObservableValue)this.centerY);
                this.group.getChildren().add((Object)this.lineB);
                this.lineC = new Line();
                this.lineC.startXProperty().bind((ObservableValue)this.targetX);
                this.lineC.startYProperty().bind((ObservableValue)this.centerY);
                this.lineC.endXProperty().bind((ObservableValue)this.targetX);
                this.lineC.endYProperty().bind((ObservableValue)this.targetY);
                this.group.getChildren().add((Object)this.lineC);
            }
            this.text.xProperty().bind((ObservableValue)this.centerX.subtract((ObservableNumberValue)textWidth.divide(2)));
            this.text.yProperty().bind((ObservableValue)this.centerY.subtract((ObservableNumberValue)textHeight.divide(2)));
            this.group.getChildren().add((Object)this.text);
            this.getChildren().add((Object)this.group);
        }

        public DoubleBinding getSourceX() {
            return this.sourceX;
        }

        public DoubleBinding getSourceY() {
            return this.sourceY;
        }

        public DoubleBinding getTargetX() {
            return this.targetX;
        }

        public DoubleBinding getTargetY() {
            return this.targetY;
        }

        public DoubleBinding getCenterX() {
            return this.centerX;
        }

        public DoubleBinding getCenterY() {
            return this.centerY;
        }

        public Group getGroup() {
            return this.group;
        }

        public Line getLineA() {
            return this.lineA;
        }

        public Line getLineB() {
            return this.lineB;
        }

        public Line getLineC() {
            return this.lineC;
        }

        public Text getText() {
            return this.text;
        }

        private /* synthetic */ void lambda$new$0(DoubleProperty textWidth, DoubleProperty textHeight) {
            textWidth.set(this.text.getLayoutBounds().getWidth());
            textHeight.set(this.text.getLayoutBounds().getHeight());
        }
    }
}

