/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.edges;

import com.fxgraph.edges.AbstractEdge;
import com.fxgraph.graph.Graph;
import com.fxgraph.graph.ICell;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;

public class Edge
extends AbstractEdge {
    private final transient StringProperty textProperty = new SimpleStringProperty();

    public Edge(ICell source, ICell target) {
        super(source, target);
    }

    public EdgeGraphic getGraphic(Graph graph) {
        return new EdgeGraphic(graph, this, this.textProperty);
    }

    public StringProperty textProperty() {
        return this.textProperty;
    }

    public static class EdgeGraphic
    extends Pane {
        private final Group group = new Group();
        private final Line line = new Line();
        private final Text text;

        public EdgeGraphic(Graph graph, Edge edge, StringProperty textProperty) {
            DoubleBinding sourceX = edge.getSource().getXAnchor(graph, edge);
            DoubleBinding sourceY = edge.getSource().getYAnchor(graph, edge);
            DoubleBinding targetX = edge.getTarget().getXAnchor(graph, edge);
            DoubleBinding targetY = edge.getTarget().getYAnchor(graph, edge);
            this.line.startXProperty().bind((ObservableValue)sourceX);
            this.line.startYProperty().bind((ObservableValue)sourceY);
            this.line.endXProperty().bind((ObservableValue)targetX);
            this.line.endYProperty().bind((ObservableValue)targetY);
            this.group.getChildren().add((Object)this.line);
            SimpleDoubleProperty textWidth = new SimpleDoubleProperty();
            SimpleDoubleProperty textHeight = new SimpleDoubleProperty();
            this.text = new Text();
            this.text.textProperty().bind((ObservableValue)textProperty);
            this.text.getStyleClass().add((Object)"edge-text");
            this.text.xProperty().bind((ObservableValue)this.line.startXProperty().add((ObservableNumberValue)this.line.endXProperty()).divide(2).subtract((ObservableNumberValue)textWidth.divide(2)));
            this.text.yProperty().bind((ObservableValue)this.line.startYProperty().add((ObservableNumberValue)this.line.endYProperty()).divide(2).subtract((ObservableNumberValue)textHeight.divide(2)));
            Runnable recalculateWidth = () -> this.lambda$new$0((DoubleProperty)textWidth, (DoubleProperty)textHeight);
            this.text.parentProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            this.text.textProperty().addListener((obs, oldVal, newVal) -> recalculateWidth.run());
            this.group.getChildren().add((Object)this.text);
            this.getChildren().add((Object)this.group);
        }

        public Group getGroup() {
            return this.group;
        }

        public Line getLine() {
            return this.line;
        }

        public Text getText() {
            return this.text;
        }

        private /* synthetic */ void lambda$new$0(DoubleProperty textWidth, DoubleProperty textHeight) {
            textWidth.set(this.text.getLayoutBounds().getWidth());
            textHeight.set(this.text.getLayoutBounds().getHeight());
        }
    }
}

