/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.graph;

import com.fxgraph.graph.ICell;
import com.fxgraph.graph.IEdge;
import com.fxgraph.graph.IGraphNode;
import com.fxgraph.graph.Model;
import com.fxgraph.graph.NodeGestures;
import com.fxgraph.graph.PannableCanvas;
import com.fxgraph.graph.ViewportGestures;
import com.fxgraph.layout.Layout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;

public class Graph {
    private final Model model;
    private final PannableCanvas pannableCanvas;
    private final Map<IGraphNode, Region> graphics;
    private final NodeGestures nodeGestures;
    private final ViewportGestures viewportGestures;
    private final BooleanProperty useNodeGestures;
    private final BooleanProperty useViewportGestures;

    public Graph() {
        this(new Model());
    }

    public Graph(Model model) {
        this.model = model;
        this.nodeGestures = new NodeGestures(this);
        this.useNodeGestures = new SimpleBooleanProperty(true);
        this.useNodeGestures.addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                model.getAllCells().forEach(cell -> this.nodeGestures.makeDraggable((Node)this.getGraphic((IGraphNode)cell)));
            } else {
                model.getAllCells().forEach(cell -> this.nodeGestures.makeUndraggable((Node)this.getGraphic((IGraphNode)cell)));
            }
        });
        this.pannableCanvas = new PannableCanvas();
        this.viewportGestures = new ViewportGestures(this.pannableCanvas);
        this.useViewportGestures = new SimpleBooleanProperty(true);
        this.useViewportGestures.addListener((obs, oldVal, newVal) -> {
            Parent parent = (Parent)this.pannableCanvas.parentProperty().get();
            if (parent == null) {
                return;
            }
            if (newVal.booleanValue()) {
                parent.addEventHandler(MouseEvent.MOUSE_PRESSED, this.viewportGestures.getOnMousePressedEventHandler());
                parent.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.viewportGestures.getOnMouseDraggedEventHandler());
                parent.addEventHandler(ScrollEvent.ANY, this.viewportGestures.getOnScrollEventHandler());
            } else {
                parent.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.viewportGestures.getOnMousePressedEventHandler());
                parent.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.viewportGestures.getOnMouseDraggedEventHandler());
                parent.removeEventHandler(ScrollEvent.ANY, this.viewportGestures.getOnScrollEventHandler());
            }
        });
        this.pannableCanvas.parentProperty().addListener((obs, oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.viewportGestures.getOnMousePressedEventHandler());
                oldVal.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.viewportGestures.getOnMouseDraggedEventHandler());
                oldVal.removeEventHandler(ScrollEvent.ANY, this.viewportGestures.getOnScrollEventHandler());
            }
            if (newVal != null) {
                newVal.addEventHandler(MouseEvent.MOUSE_PRESSED, this.viewportGestures.getOnMousePressedEventHandler());
                newVal.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.viewportGestures.getOnMouseDraggedEventHandler());
                newVal.addEventHandler(ScrollEvent.ANY, this.viewportGestures.getOnScrollEventHandler());
            }
        });
        this.graphics = new HashMap<IGraphNode, Region>();
        this.addEdges((List<IEdge>)this.getModel().getAllEdges());
        this.addCells((List<ICell>)this.getModel().getAllCells());
    }

    public PannableCanvas getCanvas() {
        return this.pannableCanvas;
    }

    public Model getModel() {
        return this.model;
    }

    public void beginUpdate() {
        this.getCanvas().getChildren().clear();
    }

    public void endUpdate() {
        this.addEdges((List<IEdge>)this.model.getAddedEdges());
        this.addCells((List<ICell>)this.model.getAddedCells());
        this.model.getRemovedCells().stream().map(cell -> this.getGraphic((IGraphNode)cell)).forEach(cellGraphic -> this.getCanvas().getChildren().remove(cellGraphic));
        this.model.getRemovedEdges().stream().map(edge -> this.getGraphic((IGraphNode)edge)).forEach(edgeGraphic -> this.getCanvas().getChildren().remove(edgeGraphic));
        this.getModel().endUpdate();
    }

    private void addEdges(List<IEdge> edges) {
        edges.stream().map(edge -> {
            try {
                return this.getGraphic((IGraphNode)edge);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to get graphic for " + edge, e);
            }
        }).forEach(edgeGraphic -> this.getCanvas().getChildren().add(edgeGraphic));
    }

    private void addCells(List<ICell> cells) {
        cells.stream().map(cell -> this.getGraphic((IGraphNode)cell)).forEach(cellGraphic -> {
            this.getCanvas().getChildren().add(cellGraphic);
            if (this.useNodeGestures.get()) {
                this.nodeGestures.makeDraggable((Node)cellGraphic);
            }
        });
    }

    public Region getGraphic(IGraphNode node) {
        try {
            if (!this.graphics.containsKey(node)) {
                this.graphics.put(node, this.createGraphic(node));
            }
            return this.graphics.get(node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Region createGraphic(IGraphNode node) {
        return node.getGraphic(this);
    }

    public double getScale() {
        return this.getCanvas().getScale();
    }

    public void layout(Layout layout) {
        layout.execute(this);
    }

    public NodeGestures getNodeGestures() {
        return this.nodeGestures;
    }

    public BooleanProperty getUseNodeGestures() {
        return this.useNodeGestures;
    }

    public ViewportGestures getViewportGestures() {
        return this.viewportGestures;
    }

    public BooleanProperty getUseViewportGestures() {
        return this.useViewportGestures;
    }
}

