/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.graph;

import com.fxgraph.cells.RectangleCell;
import com.fxgraph.cells.TriangleCell;
import com.fxgraph.edges.CorneredEdge;
import com.fxgraph.edges.DoubleCorneredEdge;
import com.fxgraph.edges.Edge;
import com.fxgraph.graph.Graph;
import com.fxgraph.graph.Model;
import com.fxgraph.layout.AbegoTreeLayout;
import com.fxgraph.layout.RandomLayout;
import javafx.application.Application;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.abego.treelayout.Configuration;

public class MainApp
extends Application {
    Graph graph = new Graph();

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        this.graph = new Graph();
        root.setCenter((Node)this.graph.getCanvas());
        Scene scene = new Scene((Parent)root, 1024.0, 768.0);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/application.css").toExternalForm());
        primaryStage.setScene(scene);
        primaryStage.show();
        this.addTreeComponents();
        this.graph.layout(new AbegoTreeLayout(200.0, 200.0, Configuration.Location.Top));
    }

    private void addGraphComponents() {
        Model model = this.graph.getModel();
        this.graph.beginUpdate();
        RectangleCell cellA = new RectangleCell();
        RectangleCell cellB = new RectangleCell();
        RectangleCell cellC = new RectangleCell();
        TriangleCell cellD = new TriangleCell();
        TriangleCell cellE = new TriangleCell();
        RectangleCell cellF = new RectangleCell();
        RectangleCell cellG = new RectangleCell();
        model.addCell(cellA);
        model.addCell(cellB);
        model.addCell(cellC);
        model.addCell(cellD);
        model.addCell(cellE);
        model.addCell(cellF);
        model.addCell(cellG);
        model.addEdge(cellA, cellB);
        model.addEdge(cellA, cellC);
        model.addEdge(cellB, cellC);
        model.addEdge(cellC, cellD);
        model.addEdge(cellB, cellE);
        model.addEdge(cellD, cellF);
        Edge edge = new Edge(cellD, cellG);
        edge.textProperty().set((Object)"Edges can have text too!");
        model.addEdge(edge);
        this.graph.endUpdate();
        this.graph.layout(new RandomLayout());
    }

    private void addTreeComponents() {
        Model model = this.graph.getModel();
        this.graph.beginUpdate();
        RectangleCell cellA = new RectangleCell();
        RectangleCell cellB = new RectangleCell();
        RectangleCell cellC = new RectangleCell();
        TriangleCell cellD = new TriangleCell();
        TriangleCell cellE = new TriangleCell();
        RectangleCell cellF = new RectangleCell();
        RectangleCell cellG = new RectangleCell();
        model.addCell(cellA);
        model.addCell(cellB);
        model.addCell(cellC);
        model.addCell(cellD);
        model.addCell(cellE);
        model.addCell(cellF);
        model.addCell(cellG);
        Edge edgeAB = new Edge(cellA, cellB);
        edgeAB.textProperty().set((Object)"Edges can have text too!");
        model.addEdge(edgeAB);
        CorneredEdge edgeAC = new CorneredEdge(cellA, cellC, Orientation.HORIZONTAL);
        edgeAC.textProperty().set((Object)"Edges can have corners too!");
        model.addEdge(edgeAC);
        model.addEdge(cellB, cellD);
        DoubleCorneredEdge edgeBE = new DoubleCorneredEdge(cellB, cellE, Orientation.HORIZONTAL);
        edgeBE.textProperty().set((Object)"You can implement custom edges and nodes too!");
        model.addEdge(edgeBE);
        model.addEdge(cellC, cellF);
        model.addEdge(cellC, cellG);
        this.graph.endUpdate();
    }

    public static void main(String[] args) {
        MainApp.launch((String[])args);
    }
}

