/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.graph;

import com.fxgraph.cells.AbstractCell;
import com.fxgraph.edges.Edge;
import com.fxgraph.graph.Graph;
import com.fxgraph.graph.ICell;
import com.fxgraph.graph.IEdge;
import java.io.Serializable;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;

public class Model
implements Serializable {
    private static final long serialVersionUID = 172247271876446110L;
    private final ICell root = new AbstractCell(){

        @Override
        public Region getGraphic(Graph graph) {
            return null;
        }
    };
    private ObservableList<ICell> allCells;
    private transient ObservableList<ICell> addedCells;
    private transient ObservableList<ICell> removedCells;
    private ObservableList<IEdge> allEdges;
    private transient ObservableList<IEdge> addedEdges;
    private transient ObservableList<IEdge> removedEdges;

    public Model() {
        this.clear();
    }

    public void clear() {
        this.allCells = FXCollections.observableArrayList();
        this.addedCells = FXCollections.observableArrayList();
        this.removedCells = FXCollections.observableArrayList();
        this.allEdges = FXCollections.observableArrayList();
        this.addedEdges = FXCollections.observableArrayList();
        this.removedEdges = FXCollections.observableArrayList();
    }

    public void clearAddedLists() {
        this.addedCells.clear();
        this.addedEdges.clear();
    }

    public void endUpdate() {
        this.attachOrphansToGraphParent((List<ICell>)this.getAddedCells());
        this.disconnectFromGraphParent((List<ICell>)this.getRemovedCells());
        this.merge();
    }

    public ObservableList<ICell> getAddedCells() {
        return this.addedCells;
    }

    public ObservableList<ICell> getRemovedCells() {
        return this.removedCells;
    }

    public ObservableList<ICell> getAllCells() {
        return this.allCells;
    }

    public ObservableList<IEdge> getAddedEdges() {
        return this.addedEdges;
    }

    public ObservableList<IEdge> getRemovedEdges() {
        return this.removedEdges;
    }

    public ObservableList<IEdge> getAllEdges() {
        return this.allEdges;
    }

    public void addCell(ICell cell) {
        if (cell == null) {
            throw new NullPointerException("Cannot add a null cell");
        }
        this.addedCells.add((Object)cell);
    }

    public void addEdge(ICell sourceCell, ICell targetCell) {
        Edge edge = new Edge(sourceCell, targetCell);
        this.addEdge(edge);
    }

    public void addEdge(IEdge edge) {
        if (edge == null) {
            throw new NullPointerException("Cannot add a null edge");
        }
        this.addedEdges.add((Object)edge);
    }

    public void attachOrphansToGraphParent(List<ICell> cellList) {
        for (ICell cell : cellList) {
            if (cell.getCellParents().size() != 0) continue;
            this.root.addCellChild(cell);
        }
    }

    public void disconnectFromGraphParent(List<ICell> cellList) {
        for (ICell cell : cellList) {
            this.root.removeCellChild(cell);
        }
    }

    public ICell getRoot() {
        return this.root;
    }

    public void merge() {
        this.allCells.addAll(this.addedCells);
        this.allCells.removeAll(this.removedCells);
        this.addedCells.clear();
        this.removedCells.clear();
        this.allEdges.addAll(this.addedEdges);
        this.allEdges.removeAll(this.removedEdges);
        this.addedEdges.clear();
        this.removedEdges.clear();
    }
}

