/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.graph;

import com.fxgraph.graph.Graph;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class NodeGestures {
    final DragContext dragContext = new DragContext();
    final Graph graph;
    final EventHandler<MouseEvent> onMousePressedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Node node = (Node)event.getSource();
            double scale = NodeGestures.this.graph.getScale();
            NodeGestures.this.dragContext.x = node.getBoundsInParent().getMinX() * scale - event.getScreenX();
            NodeGestures.this.dragContext.y = node.getBoundsInParent().getMinY() * scale - event.getScreenY();
        }
    };
    final EventHandler<MouseEvent> onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Node node = (Node)event.getSource();
            double offsetX = event.getScreenX() + NodeGestures.this.dragContext.x;
            double offsetY = event.getScreenY() + NodeGestures.this.dragContext.y;
            double scale = NodeGestures.this.graph.getScale();
            node.relocate(offsetX /= scale, offsetY /= scale);
        }
    };
    final EventHandler<MouseEvent> onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
        }
    };

    public NodeGestures(Graph graph) {
        this.graph = graph;
    }

    public void makeDraggable(Node node) {
        node.setOnMousePressed(this.onMousePressedEventHandler);
        node.setOnMouseDragged(this.onMouseDraggedEventHandler);
        node.setOnMouseReleased(this.onMouseReleasedEventHandler);
    }

    public void makeUndraggable(Node node) {
        node.setOnMousePressed(null);
        node.setOnMouseDragged(null);
        node.setOnMouseReleased(null);
    }

    public static class DragContext {
        double x;
        double y;
    }
}

