/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.graph;

import com.fxgraph.graph.PannableCanvas;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class ViewportGestures {
    private final DoubleProperty zoomSpeedProperty = new SimpleDoubleProperty(1.2);
    private final DoubleProperty maxScaleProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty minScaleProperty = new SimpleDoubleProperty(0.1);
    private final PannableCanvas.DragContext sceneDragContext = new PannableCanvas.DragContext();
    PannableCanvas canvas;
    private final EventHandler<MouseEvent> onMousePressedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!event.isSecondaryButtonDown()) {
                return;
            }
            ((ViewportGestures)ViewportGestures.this).sceneDragContext.mouseAnchorX = event.getSceneX();
            ((ViewportGestures)ViewportGestures.this).sceneDragContext.mouseAnchorY = event.getSceneY();
            ((ViewportGestures)ViewportGestures.this).sceneDragContext.translateAnchorX = ViewportGestures.this.canvas.getTranslateX();
            ((ViewportGestures)ViewportGestures.this).sceneDragContext.translateAnchorY = ViewportGestures.this.canvas.getTranslateY();
        }
    };
    private final EventHandler<MouseEvent> onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!event.isSecondaryButtonDown()) {
                return;
            }
            ViewportGestures.this.canvas.setTranslateX(((ViewportGestures)ViewportGestures.this).sceneDragContext.translateAnchorX + event.getSceneX() - ((ViewportGestures)ViewportGestures.this).sceneDragContext.mouseAnchorX);
            ViewportGestures.this.canvas.setTranslateY(((ViewportGestures)ViewportGestures.this).sceneDragContext.translateAnchorY + event.getSceneY() - ((ViewportGestures)ViewportGestures.this).sceneDragContext.mouseAnchorY);
            event.consume();
        }
    };
    private final EventHandler<ScrollEvent> onScrollEventHandler = new EventHandler<ScrollEvent>(){

        public void handle(ScrollEvent event) {
            double scale;
            double oldScale = scale = ViewportGestures.this.canvas.getScale();
            scale = event.getDeltaY() < 0.0 ? (scale /= ViewportGestures.this.getZoomSpeed()) : (scale *= ViewportGestures.this.getZoomSpeed());
            scale = ViewportGestures.clamp(scale, ViewportGestures.this.minScaleProperty.get(), ViewportGestures.this.maxScaleProperty.get());
            double f = scale / oldScale - 1.0;
            double maxX = ViewportGestures.this.canvas.getBoundsInParent().getMaxX() - ViewportGestures.this.canvas.localToParent(ViewportGestures.this.canvas.getPrefWidth(), ViewportGestures.this.canvas.getPrefHeight()).getX();
            double maxY = ViewportGestures.this.canvas.getBoundsInParent().getMaxY() - ViewportGestures.this.canvas.localToParent(ViewportGestures.this.canvas.getPrefWidth(), ViewportGestures.this.canvas.getPrefHeight()).getY();
            double minX = ViewportGestures.this.canvas.localToParent(0.0, 0.0).getX() - ViewportGestures.this.canvas.getBoundsInParent().getMinX();
            double minY = ViewportGestures.this.canvas.localToParent(0.0, 0.0).getY() - ViewportGestures.this.canvas.getBoundsInParent().getMinY();
            double subX = maxX + minX;
            double subY = maxY + minY;
            double dx = event.getSceneX() - ((ViewportGestures.this.canvas.getBoundsInParent().getWidth() - subX) / 2.0 + (ViewportGestures.this.canvas.getBoundsInParent().getMinX() + minX));
            double dy = event.getSceneY() - ((ViewportGestures.this.canvas.getBoundsInParent().getHeight() - subY) / 2.0 + (ViewportGestures.this.canvas.getBoundsInParent().getMinY() + minY));
            ViewportGestures.this.canvas.setScale(scale);
            ViewportGestures.this.canvas.setPivot(f * dx, f * dy);
            event.consume();
        }
    };

    public ViewportGestures(PannableCanvas canvas) {
        this.canvas = canvas;
    }

    public EventHandler<MouseEvent> getOnMousePressedEventHandler() {
        return this.onMousePressedEventHandler;
    }

    public EventHandler<MouseEvent> getOnMouseDraggedEventHandler() {
        return this.onMouseDraggedEventHandler;
    }

    public EventHandler<ScrollEvent> getOnScrollEventHandler() {
        return this.onScrollEventHandler;
    }

    public void setZoomBounds(double minScale, double maxScale) {
        this.minScaleProperty.set(minScale);
        this.maxScaleProperty.set(maxScale);
    }

    public static double clamp(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    public double getMinScale() {
        return this.minScaleProperty.get();
    }

    public void setMinScale(double minScale) {
        this.minScaleProperty.set(minScale);
    }

    public DoubleProperty minScaleProperty() {
        return this.minScaleProperty;
    }

    public double getMaxScale() {
        return this.maxScaleProperty.get();
    }

    public DoubleProperty maxScaleProperty() {
        return this.maxScaleProperty;
    }

    public void setMaxScale(double maxScale) {
        this.maxScaleProperty.set(maxScale);
    }

    public double getZoomSpeed() {
        return this.zoomSpeedProperty.get();
    }

    public DoubleProperty zoomSpeedProperty() {
        return this.zoomSpeedProperty;
    }

    public void setZoomSpeed(double zoomSpeed) {
        this.zoomSpeedProperty.set(zoomSpeed);
    }
}

