/*
 * Decompiled with CFR 0.152.
 */
package com.fxgraph.layout;

import com.fxgraph.graph.Graph;
import com.fxgraph.graph.ICell;
import com.fxgraph.graph.IGraphNode;
import com.fxgraph.layout.Layout;
import java.awt.geom.Rectangle2D;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.util.DefaultConfiguration;
import org.abego.treelayout.util.DefaultTreeForTreeLayout;

public class AbegoTreeLayout
implements Layout {
    private final Configuration<ICell> configuration;

    public AbegoTreeLayout() {
        this(100.0, 45.0, Configuration.Location.Top);
    }

    public AbegoTreeLayout(double gapBetweenLevels, double gapBetweenNodes, Configuration.Location location) {
        this((Configuration<ICell>)new DefaultConfiguration(gapBetweenLevels, gapBetweenNodes, location));
    }

    public AbegoTreeLayout(Configuration<ICell> configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(final Graph graph) {
        DefaultTreeForTreeLayout layout = new DefaultTreeForTreeLayout((Object)graph.getModel().getRoot());
        this.addRecursively((DefaultTreeForTreeLayout<ICell>)layout, graph.getModel().getRoot());
        NodeExtentProvider<ICell> nodeExtentProvider = new NodeExtentProvider<ICell>(){

            public double getWidth(ICell tn) {
                if (tn == graph.getModel().getRoot()) {
                    return 0.0;
                }
                return graph.getGraphic(tn).getWidth();
            }

            public double getHeight(ICell tn) {
                if (tn == graph.getModel().getRoot()) {
                    return 0.0;
                }
                return graph.getGraphic(tn).getHeight();
            }
        };
        TreeLayout treeLayout = new TreeLayout((TreeForTreeLayout)layout, (NodeExtentProvider)nodeExtentProvider, this.configuration);
        treeLayout.getNodeBounds().entrySet().stream().filter(entry -> entry.getKey() != graph.getModel().getRoot()).forEach(entry -> {
            graph.getGraphic((IGraphNode)entry.getKey()).setLayoutX(((Rectangle2D.Double)entry.getValue()).getX());
            graph.getGraphic((IGraphNode)entry.getKey()).setLayoutY(((Rectangle2D.Double)entry.getValue()).getY());
        });
    }

    public void addRecursively(DefaultTreeForTreeLayout<ICell> layout, ICell node) {
        node.getCellChildren().forEach(cell -> {
            if (!layout.hasNode(cell)) {
                layout.addChild((Object)node, cell);
                this.addRecursively(layout, (ICell)cell);
            }
        });
    }
}

