/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.cohort.hikari;

import com.sksamuel.cohort.HealthCheck;
import com.sksamuel.cohort.HealthCheckResult;
import com.zaxxer.hikari.HikariDataSource;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcom/sksamuel/cohort/hikari/HikariConnectionsHealthCheck;", "Lcom/sksamuel/cohort/HealthCheck;", "ds", "Lcom/zaxxer/hikari/HikariDataSource;", "minConnections", "", "name", "", "(Lcom/zaxxer/hikari/HikariDataSource;ILjava/lang/String;)V", "getName", "()Ljava/lang/String;", "check", "Lcom/sksamuel/cohort/HealthCheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cohort-hikari"})
public final class HikariConnectionsHealthCheck
implements HealthCheck {
    @NotNull
    private final HikariDataSource ds;
    private final int minConnections;
    @NotNull
    private final String name;

    public HikariConnectionsHealthCheck(@NotNull HikariDataSource ds, int minConnections, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ds = ds;
        this.minConnections = minConnections;
        this.name = name;
    }

    public /* synthetic */ HikariConnectionsHealthCheck(HikariDataSource hikariDataSource, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string = "hikari_open_connections";
        }
        this(hikariDataSource, n, string);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object check(@NotNull Continuation<? super HealthCheckResult> $completion) {
        int conns = this.ds.getHikariPoolMXBean().getTotalConnections();
        String msg = conns + " connection(s) to Hikari db-pool " + this.ds.getPoolName() + " [minConnections:" + this.minConnections + "]";
        return conns >= this.minConnections ? HealthCheckResult.Companion.healthy(msg) : HealthCheckResult.Companion.unhealthy(msg, null);
    }
}

