/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.akka;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.javadsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethod$;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCode$;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.BasicHttpCredentials;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.parboiled2.ParserInput;
import akka.parboiled2.ParserInput$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.OverflowStrategy$;
import akka.stream.QueueOfferResult;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.SourceQueueWithComplete;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.sksamuel.elastic4s.ElasticRequest;
import com.sksamuel.elastic4s.HttpClient;
import com.sksamuel.elastic4s.HttpEntity;
import com.sksamuel.elastic4s.HttpResponse;
import com.sksamuel.elastic4s.akka.AkkaHttpClient$;
import com.sksamuel.elastic4s.akka.AkkaHttpClient$AllHostsBlacklistedException$;
import com.sksamuel.elastic4s.akka.AkkaHttpClient$RequestState$;
import com.sksamuel.elastic4s.akka.AkkaHttpClientSettings;
import com.sksamuel.elastic4s.akka.Blacklist;
import com.sksamuel.elastic4s.akka.HttpPoolFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\rMb\u0001B\"E\u00015C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015a\u0003i\u0011\u0019y\u0007\u0001\"\u0001Ea\"9q\u000f\u0001b\u0001\n\u0017A\bBB@\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A!Q\u000e\u0001!\u0002\u0013\t\t\u0002C\u0004\u0003p\u0001!IA!\u001d\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!1\u0012\u0001\u0005\n\t5\u0005\"\u0003BN\u0001E\u0005I\u0011\u0002BO\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GC\u0001Ba/\u0001\t\u0003!%Q\u0018\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005KDqA!;\u0001\t\u0003\u0012Y\u000fC\u0004\u0003n\u0002!IAa<\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n!91q\u0004\u0001\u0005\n\r\u0005raBA\u001a\t\"\u0005\u0011Q\u0007\u0004\u0007\u0007\u0012C\t!a\u000e\t\r=LB\u0011AA \u0011\u001d\t\t%\u0007C\u0001\u0003\u00072q!a\u0013\u001a\u0001\u0012\u000bi\u0005\u0003\u0006\u0002nq\u0011)\u001a!C\u0001\u0003_B!\"a!\u001d\u0005#\u0005\u000b\u0011BA9\u0011)\t)\t\bBK\u0002\u0013\u0005\u0011q\u0011\u0005\u000b\u00033c\"\u0011#Q\u0001\n\u0005%\u0005BB8\u001d\t\u0003\tY\nC\u0005\u0002&r\t\t\u0011\"\u0001\u0002(\"I\u0011Q\u0016\u000f\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003\u000bd\u0012\u0013!C\u0001\u0003\u000fD\u0011\"a3\u001d\u0003\u0003%\t%a\u0001\t\u0013\u00055G$!A\u0005\u0002\u0005=\u0007\"CAl9\u0005\u0005I\u0011AAm\u0011%\t)\u000fHA\u0001\n\u0003\n9\u000fC\u0005\u0002vr\t\t\u0011\"\u0001\u0002x\"I!\u0011\u0001\u000f\u0002\u0002\u0013\u0005#1\u0001\u0005\n\u0005\u000fa\u0012\u0011!C!\u0005\u0013A\u0011Ba\u0003\u001d\u0003\u0003%\tE!\u0004\t\u0013\t=A$!A\u0005B\tEqA\u0003B\u000b3\u0005\u0005\t\u0012\u0001#\u0003\u0018\u0019Q\u00111J\r\u0002\u0002#\u0005AI!\u0007\t\r=|C\u0011\u0001B\u0019\u0011%\u0011YaLA\u0001\n\u000b\u0012i\u0001C\u0005\u0002B=\n\t\u0011\"!\u00034!I!\u0011H\u0018\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0005wy\u0013\u0013!C\u0001\u0003\u000fD\u0011B!\u00100\u0003\u0003%\tIa\u0010\t\u0013\t5s&%A\u0005\u0002\u0005=\u0006\"\u0003B(_E\u0005I\u0011AAd\u0011%\u0011\tfLA\u0001\n\u0013\u0011\u0019f\u0002\u0005\u0003VeA\t\t\u0012B,\r!\u0011I&\u0007EA\t\nm\u0003BB8;\t\u0003\u0011\u0019\u0007C\u0005\u0002Lj\n\t\u0011\"\u0011\u0002\u0004!I\u0011Q\u001a\u001e\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/T\u0014\u0011!C\u0001\u0005KB\u0011\"!:;\u0003\u0003%\t%a:\t\u0013\u0005U((!A\u0005\u0002\t%\u0004\"\u0003B\u0004u\u0005\u0005I\u0011\tB\u0005\u0011%\u0011\tFOA\u0001\n\u0013\u0011\u0019F\u0001\bBW.\f\u0007\n\u001e;q\u00072LWM\u001c;\u000b\u0005\u00153\u0015\u0001B1lW\u0006T!a\u0012%\u0002\u0013\u0015d\u0017m\u001d;jGR\u001a(BA%K\u0003!\u00198n]1nk\u0016d'\"A&\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qe\u000b\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006!A.\u00198h\u0015\u0005\u0019\u0016\u0001\u00026bm\u0006L!!\u0016)\u0003\r=\u0013'.Z2u!\t9\u0006,D\u0001G\u0013\tIfI\u0001\u0006IiR\u00048\t\\5f]R\f\u0001b]3ui&twm\u001d\t\u00039vk\u0011\u0001R\u0005\u0003=\u0012\u0013a#Q6lC\"#H\u000f]\"mS\u0016tGoU3ui&twm]\u0001\nE2\f7m\u001b7jgR\u0004\"\u0001X1\n\u0005\t$%!\u0003\"mC\u000e\\G.[:u\u0003=AG\u000f\u001e9Q_>dg)Y2u_JL\bC\u0001/f\u0013\t1GIA\bIiR\u0004\bk\\8m\r\u0006\u001cGo\u001c:z\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0011.\\\u0007\u0002U*\u00111\u000e\\\u0001\u0006C\u000e$xN\u001d\u0006\u0002\u000b&\u0011aN\u001b\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0005cR,h\u000f\u0006\u0002sgB\u0011A\f\u0001\u0005\u0006O\u0016\u0001\u001d\u0001\u001b\u0005\u00065\u0016\u0001\ra\u0017\u0005\u0006?\u0016\u0001\r\u0001\u0019\u0005\u0006G\u0016\u0001\r\u0001Z\u0001\r[\u0006$XM]5bY&TXM]\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011A\u0010\\\u0001\u0007gR\u0014X-Y7\n\u0005y\\(\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004tG\",W.Z\u000b\u0003\u0003\u000b\u00012aTA\u0004\u0013\r\tI\u0001\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fM\u001c\u0007.Z7fA\u0005)\u0011/^3vKV\u0011\u0011\u0011\u0003\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!bAA\fw\u0006A1oY1mC\u0012\u001cH.\u0003\u0003\u0002\u001c\u0005U!aF*pkJ\u001cW-U;fk\u0016<\u0016\u000e\u001e5D_6\u0004H.\u001a;f!!\ty\"!\n\u0002*\u0005=RBAA\u0011\u0015\t\t\u0019#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002(\u0005\u0005\"A\u0002+va2,'\u0007E\u0002X\u0003WI1!!\fG\u00059)E.Y:uS\u000e\u0014V-];fgR\u00042!!\r\u001d\u001d\ta\u0006$\u0001\bBW.\f\u0007\n\u001e;q\u00072LWM\u001c;\u0011\u0005qK2cA\r\u0002:A!\u0011qDA\u001e\u0013\u0011\ti$!\t\u0003\r\u0005s\u0017PU3g)\t\t)$A\u0003baBd\u0017\u0010\u0006\u0003\u0002F\u0005%Cc\u0001:\u0002H!)qm\u0007a\u0002Q\")!l\u0007a\u00017\na!+Z9vKN$8\u000b^1uKN9A$!\u000f\u0002P\u0005U\u0003\u0003BA\u0010\u0003#JA!a\u0015\u0002\"\t9\u0001K]8ek\u000e$\b\u0003BA,\u0003OrA!!\u0017\u0002d9!\u00111LA1\u001b\t\tiFC\u0002\u0002`1\u000ba\u0001\u0010:p_Rt\u0014BAA\u0012\u0013\u0011\t)'!\t\u0002\u000fA\f7m[1hK&!\u0011\u0011NA6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\t)'!\t\u0002\u0011I,7\u000f]8og\u0016,\"!!\u001d\u0011\r\u0005M\u0014\u0011PA?\u001b\t\t)H\u0003\u0003\u0002x\u0005\u0005\u0012AC2p]\u000e,(O]3oi&!\u00111PA;\u0005\u001d\u0001&o\\7jg\u0016\u00042aVA@\u0013\r\t\tI\u0012\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002\nA\u0001[8tiV\u0011\u0011\u0011\u0012\t\u0007\u0003g\nI(a#\u0011\t\u00055\u0015Q\u0013\b\u0005\u0003\u001f\u000b\t\n\u0005\u0003\u0002\\\u0005\u0005\u0012\u0002BAJ\u0003C\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003/SA!a%\u0002\"\u0005)\u0001n\\:uAQ1\u0011QTAQ\u0003G\u00032!a(\u001d\u001b\u0005I\u0002\"CA7CA\u0005\t\u0019AA9\u0011%\t))\tI\u0001\u0002\u0004\tI)\u0001\u0003d_BLHCBAO\u0003S\u000bY\u000bC\u0005\u0002n\t\u0002\n\u00111\u0001\u0002r!I\u0011Q\u0011\u0012\u0011\u0002\u0003\u0007\u0011\u0011R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tL\u000b\u0003\u0002r\u0005M6FAA[!\u0011\t9,!1\u000e\u0005\u0005e&\u0002BA^\u0003{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005}\u0016\u0011E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAb\u0003s\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!3+\t\u0005%\u00151W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0007\u0003BA\u0010\u0003'LA!!6\u0002\"\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\\Aq!\u0011\ty\"!8\n\t\u0005}\u0017\u0011\u0005\u0002\u0004\u0003:L\b\"CArO\u0005\u0005\t\u0019AAi\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001e\t\u0007\u0003W\f\t0a7\u000e\u0005\u00055(\u0002BAx\u0003C\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u00190!<\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\fy\u0010\u0005\u0003\u0002 \u0005m\u0018\u0002BA\u007f\u0003C\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002d&\n\t\u00111\u0001\u0002\\\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)A!\u0002\t\u0013\u0005\r(&!AA\u0002\u0005E\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002z\nM\u0001\"CAr[\u0005\u0005\t\u0019AAn\u00031\u0011V-];fgR\u001cF/\u0019;f!\r\tyjL\n\u0006_\tm!q\u0005\t\u000b\u0005;\u0011\u0019#!\u001d\u0002\n\u0006uUB\u0001B\u0010\u0015\u0011\u0011\t#!\t\u0002\u000fI,h\u000e^5nK&!!Q\u0005B\u0010\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)\u0019!Q\u0006*\u0002\u0005%|\u0017\u0002BA5\u0005W!\"Aa\u0006\u0015\r\u0005u%Q\u0007B\u001c\u0011%\tiG\rI\u0001\u0002\u0004\t\t\bC\u0005\u0002\u0006J\u0002\n\u00111\u0001\u0002\n\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BA!\u0011\u0003JA1\u0011q\u0004B\"\u0005\u000fJAA!\u0012\u0002\"\t1q\n\u001d;j_:\u0004\u0002\"a\b\u0002&\u0005E\u0014\u0011\u0012\u0005\n\u0005\u0017*\u0014\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012AT\u0001\u001d\u00032d\u0007j\\:ug\nc\u0017mY6mSN$X\rZ#yG\u0016\u0004H/[8o!\r\tyJ\u000f\u0002\u001d\u00032d\u0007j\\:ug\nc\u0017mY6mSN$X\rZ#yG\u0016\u0004H/[8o'\u001dQ$QLA(\u0003+\u0002B!a\u0016\u0003`%!!\u0011MA6\u0005%)\u0005pY3qi&|g\u000e\u0006\u0002\u0003XQ!\u00111\u001cB4\u0011%\t\u0019OPA\u0001\u0002\u0004\t\t\u000e\u0006\u0003\u0002z\n-\u0004\"CAr\u0001\u0006\u0005\t\u0019AAn\u0003\u0019\tX/Z;fA\u0005a\u0011\u000e^3sCR,\u0007j\\:ugV\u0011!1\u000f\t\u0007\u0003/\u0012)Ha\u001e\n\t\u0005M\u00181\u000e\t\u0007\u0003?\u0011\u0019%a#\u0002\u0019E,X-^3SKF,Xm\u001d;\u0015\r\tu$1\u0011BD!\u0019\t\u0019Ha \u0002~%!!\u0011QA;\u0005\u00191U\u000f^;sK\"9!QQ\u0007A\u0002\u0005%\u0012a\u0002:fcV,7\u000f\u001e\u0005\b\u0005\u0013k\u0001\u0019AA\u0018\u0003\u0015\u0019H/\u0019;f\u0003U\tX/Z;f%\u0016\fX/Z:u/&$\bNU3uef$bA! \u0003\u0010\nE\u0005b\u0002BC\u001d\u0001\u0007\u0011\u0011\u0006\u0005\n\u0005's\u0001\u0013!a\u0001\u0005+\u000bab\u001d;beR$\u0016.\\3OC:|7\u000f\u0005\u0003\u0002 \t]\u0015\u0002\u0002BM\u0003C\u0011A\u0001T8oO\u0006y\u0012/^3vKJ+\u0017/^3ti^KG\u000f\u001b*fiJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}%\u0006\u0002BK\u0003g\u000bQ\"[:SKR\u0014\u0018p\u0015;biV\u001cH\u0003BA}\u0005KCqAa*\u0011\u0001\u0004\u0011I+\u0001\u0006ti\u0006$Xo]\"pI\u0016\u0004BAa+\u000386\u0011!Q\u0016\u0006\u0005\u0005_\u0013\t,A\u0003n_\u0012,GN\u0003\u0003\u0002\u0018\tM&b\u0001B[Y\u0006!\u0001\u000e\u001e;q\u0013\u0011\u0011IL!,\u0003\u0015M#\u0018\r^;t\u0007>$W-A\u0005tK:$\u0017i]=oGR!!Q\u0010B`\u0011\u001d\u0011))\u0005a\u0001\u0003S\tAa]3oIR1!Q\u0019Bf\u0005\u001b\u0004B!a\b\u0003H&!!\u0011ZA\u0011\u0005\u0011)f.\u001b;\t\u000f\t\u0015%\u00031\u0001\u0002*!9!q\u001a\nA\u0002\tE\u0017\u0001C2bY2\u0014\u0017mY6\u0011\u0011\u0005}!1\u001bBl\u0005\u000bLAA!6\u0002\"\tIa)\u001e8di&|g.\r\t\t\u0003/\u0012IN!8\u0002~%!!1\\A6\u0005\u0019)\u0015\u000e\u001e5feB!\u0011q\u000bBp\u0013\u0011\u0011\t/a\u001b\u0003\u0013QC'o\\<bE2,\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\t\u001d\bCBA:\u0005\u007f\u0012)-A\u0003dY>\u001cX\r\u0006\u0002\u0003F\u0006IAo\u001c*fcV,7\u000f\u001e\u000b\u0007\u0005c\u001c\u0019a!\u0002\u0011\r\tM(\u0011 B\u007f\u001b\t\u0011)P\u0003\u0003\u0003x\u0006\u0005\u0012\u0001B;uS2LAAa?\u0003v\n\u0019AK]=\u0011\t\t-&q`\u0005\u0005\u0007\u0003\u0011iKA\u0006IiR\u0004(+Z9vKN$\bb\u0002BC+\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u000b+\u0002\u0019AAF\u0003)!xNU3ta>t7/\u001a\u000b\u0007\u0003{\u001aYa!\u0005\t\u000f\u00055d\u00031\u0001\u0004\u000eA!!1VB\b\u0013\u0011\t\tI!,\t\u000f\rMa\u00031\u0001\u0004\u0016\u0005!A-\u0019;b!\u0011\u00199ba\u0007\u000e\u0005\re!b\u0001B|Y&!1QDB\r\u0005)\u0011\u0015\u0010^3TiJLgnZ\u0001\ti>,e\u000e^5usR!11EB\u0015!\u0011\u0011Yk!\n\n\t\r\u001d\"Q\u0016\u0002\u000e%\u0016\fX/Z:u\u000b:$\u0018\u000e^=\t\u000f\r-r\u00031\u0001\u0004.\u00051QM\u001c;jif\u00042aVB\u0018\u0013\r\u0019\tD\u0012\u0002\u000b\u0011R$\b/\u00128uSRL\b")
public class AkkaHttpClient
implements HttpClient {
    private final AkkaHttpClientSettings settings;
    private final Blacklist blacklist;
    private final HttpPoolFactory httpPoolFactory;
    public final ActorSystem com$sksamuel$elastic4s$akka$AkkaHttpClient$$system;
    private final Materializer materializer;
    private final String scheme;
    private final SourceQueueWithComplete<Tuple2<ElasticRequest, RequestState>> queue;
    private Logger logger;

    public static AkkaHttpClient apply(AkkaHttpClientSettings akkaHttpClientSettings, ActorSystem actorSystem) {
        return AkkaHttpClient$.MODULE$.apply(akkaHttpClientSettings, actorSystem);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$sksamuel$elastic4s$HttpClient$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Materializer materializer() {
        return this.materializer;
    }

    private String scheme() {
        return this.scheme;
    }

    private SourceQueueWithComplete<Tuple2<ElasticRequest, RequestState>> queue() {
        return this.queue;
    }

    private Iterator<Option<String>> iterateHosts() {
        return package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> $this.settings.hosts()).flatten(Predef$.MODULE$.$conforms()).flatMap((Function1 & Serializable)host -> {
            List list;
            if ($this.blacklist.contains((String)host)) {
                this.logger().trace(new StringBuilder(18).append("[").append((String)host).append("] is in blacklist").toString());
                if ($this.blacklist.size() < $this.settings.hosts().size()) {
                    list = package$.MODULE$.Nil();
                } else {
                    None$ none$ = None$.MODULE$;
                    list = package$.MODULE$.Nil().$colon$colon((Object)none$);
                }
            } else {
                Some some = new Some(host);
                list = package$.MODULE$.Nil().$colon$colon((Object)some);
            }
            return list;
        });
    }

    private Future<HttpResponse> queueRequest(ElasticRequest request, RequestState state) {
        return this.queue().offer((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)request), (Object)state)).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            QueueOfferResult queueOfferResult = x0$1;
            if (QueueOfferResult.Enqueued$.MODULE$.equals(queueOfferResult)) {
                future = state.response().future();
            } else if (QueueOfferResult.Dropped$.MODULE$.equals(queueOfferResult)) {
                future = Future$.MODULE$.failed((Throwable)new Exception("Queue overflowed. Try again later."));
            } else if (queueOfferResult instanceof QueueOfferResult.Failure) {
                QueueOfferResult.Failure failure = (QueueOfferResult.Failure)queueOfferResult;
                Throwable ex = failure.cause();
                future = Future$.MODULE$.failed(ex);
            } else if (QueueOfferResult.QueueClosed$.MODULE$.equals(queueOfferResult)) {
                future = Future$.MODULE$.failed((Throwable)new Exception("Queue was closed (pool shut down) while running the request. Try again later."));
            } else {
                throw new MatchError((Object)queueOfferResult);
            }
            return future;
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
    }

    private Future<HttpResponse> queueRequestWithRetry(ElasticRequest request, long startTimeNanos) {
        RequestState state = new RequestState(AkkaHttpClient$RequestState$.MODULE$.apply$default$1(), AkkaHttpClient$RequestState$.MODULE$.apply$default$2());
        return this.queueRequest(request, state).flatMap((Function1 & Serializable)response -> {
            StatusCode status = StatusCode$.MODULE$.int2StatusCode(response.statusCode());
            return status.isSuccess() ? this.markAlive$1(state).map((Function1 & Serializable)x$3 -> response, (ExecutionContext)$this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher()) : (this.isRetryStatus(status) ? this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$markDead$1(state).flatMap((Function1 & Serializable)x$4 -> this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$retryIfPossible$1((Function0 & Serializable)() -> package$.MODULE$.Right().apply(response), startTimeNanos, request), (ExecutionContext)$this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher()) : this.markAlive$1(state).map((Function1 & Serializable)x$5 -> response, (ExecutionContext)$this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher()));
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher()).recoverWith((PartialFunction)new Serializable(this, startTimeNanos, request, state){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AkkaHttpClient $outer;
            private final long startTimeNanos$1;
            private final ElasticRequest request$1;
            private final RequestState state$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (AkkaHttpClient$AllHostsBlacklistedException$.MODULE$.equals(A1)) {
                    A1 A12 = A1;
                    object = this.$outer.com$sksamuel$elastic4s$akka$AkkaHttpClient$$retryIfPossible$1((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)A12), this.startTimeNanos$1, this.request$1);
                } else if (A1 != null) {
                    A1 A13 = A1;
                    object = this.$outer.com$sksamuel$elastic4s$akka$AkkaHttpClient$$markDead$1(this.state$2).flatMap((Function1 & Serializable)x$6 -> $this.$outer.com$sksamuel$elastic4s$akka$AkkaHttpClient$$retryIfPossible$1((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)A13), $this.startTimeNanos$1, $this.request$1), (ExecutionContext)this.$outer.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = AkkaHttpClient$AllHostsBlacklistedException$.MODULE$.equals(throwable) ? true : throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startTimeNanos$1 = startTimeNanos$1;
                this.request$1 = request$1;
                this.state$2 = state$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable ), $anonfun$applyOrElse$2(com.sksamuel.elastic4s.akka.AkkaHttpClient$$anonfun$queueRequestWithRetry$8 java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$3(java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
    }

    private long queueRequestWithRetry$default$2() {
        return System.nanoTime();
    }

    private boolean isRetryStatus(StatusCode statusCode) {
        boolean bl;
        StatusCode statusCode2 = statusCode;
        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.BadGateway();
        StatusCode statusCode3 = statusCode2;
        if (!(serverError != null ? !serverError.equals(statusCode3) : statusCode3 != null)) {
            bl = true;
        } else {
            StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.ServiceUnavailable();
            StatusCode statusCode4 = statusCode2;
            if (!(serverError2 != null ? !serverError2.equals(statusCode4) : statusCode4 != null)) {
                bl = true;
            } else {
                StatusCodes.ServerError serverError3 = StatusCodes$.MODULE$.GatewayTimeout();
                StatusCode statusCode5 = statusCode2;
                bl = !(serverError3 != null ? !serverError3.equals(statusCode5) : statusCode5 != null);
            }
        }
        return bl;
    }

    public Future<HttpResponse> sendAsync(ElasticRequest request) {
        return this.queueRequestWithRetry(request, this.queueRequestWithRetry$default$2());
    }

    public void send(ElasticRequest request, Function1<Either<Throwable, HttpResponse>, BoxedUnit> callback) {
        this.sendAsync(request).onComplete((Function1 & Serializable)x0$1 -> {
            AkkaHttpClient.$anonfun$send$1(callback, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
    }

    public Future<BoxedUnit> shutdown() {
        return this.httpPoolFactory.shutdown();
    }

    public void close() {
        this.shutdown();
    }

    private Try<HttpRequest> toRequest(ElasticRequest request, String host) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            HttpRequest httpRequest = HttpRequest$.MODULE$.apply((HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(request.method(), (.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> HttpMethod$.MODULE$.custom(request.method())), Uri$.MODULE$.apply(request.endpoint()).withQuery(Uri.Query$.MODULE$.apply(request.params())).withAuthority(Uri.Authority$.MODULE$.parse((ParserInput)ParserInput$.MODULE$.apply(host), Uri.Authority$.MODULE$.parse$default$2(), Uri.Authority$.MODULE$.parse$default$3())).withScheme(this.scheme()), (Seq)((IterableOnceOps)request.headers().map(((Function2 & Serializable)(Function2 & Serializable)(name, value) -> new RawHeader(name, value)).tupled())).toList(), (RequestEntity)request.entity().map((Function1 & Serializable)entity -> this.toEntity((HttpEntity)entity)).getOrElse((Function0 & Serializable)() -> HttpEntity$.MODULE$.Empty()), HttpRequest$.MODULE$.apply$default$5());
            return (HttpRequest)$this.settings.requestCallback().apply($this.settings.hasCredentialsDefined() ? httpRequest.addCredentials((HttpCredentials)new BasicHttpCredentials((String)$this.settings.username().get(), (String)$this.settings.password().get())) : httpRequest);
        });
    }

    private HttpResponse toResponse(akka.http.scaladsl.model.HttpResponse response, ByteString data) {
        return new HttpResponse(response.status().intValue(), (Option)new Some((Object)new HttpEntity.StringEntity(data.utf8String(), (Option)None$.MODULE$)), ((IterableOnceOps)response.headers().map((Function1 & Serializable)h -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private RequestEntity toEntity(HttpEntity entity) {
        HttpEntity.Strict strict;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.StringEntity) {
            HttpEntity.StringEntity stringEntity = (HttpEntity.StringEntity)httpEntity;
            String content = stringEntity.content();
            Option contentType = stringEntity.contentCharset();
            ContentType ct = (ContentType)contentType.flatMap((Function1 & Serializable)value -> ContentType$.MODULE$.parse(value).right().toOption()).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029());
            strict = HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(content));
        } else if (httpEntity instanceof HttpEntity.ByteArrayEntity) {
            HttpEntity.ByteArrayEntity byteArrayEntity = (HttpEntity.ByteArrayEntity)httpEntity;
            byte[] content = byteArrayEntity.content();
            Option contentType = byteArrayEntity.contentCharset();
            ContentType ct = (ContentType)contentType.flatMap((Function1 & Serializable)value -> ContentType$.MODULE$.parse(value).right().toOption()).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029());
            strict = HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(content));
        } else if (httpEntity instanceof HttpEntity.FileEntity) {
            HttpEntity.FileEntity fileEntity = (HttpEntity.FileEntity)httpEntity;
            File file = fileEntity.content();
            Option contentType = fileEntity.contentCharset();
            ContentType ct = (ContentType)contentType.flatMap((Function1 & Serializable)value -> ContentType$.MODULE$.parse(value).right().toOption()).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.application$divoctet$minusstream());
            strict = HttpEntity$.MODULE$.apply(ct, file.length(), FileIO$.MODULE$.fromPath(file.toPath(), FileIO$.MODULE$.fromPath$default$2()));
        } else if (httpEntity instanceof HttpEntity.InputStreamEntity) {
            HttpEntity.InputStreamEntity inputStreamEntity = (HttpEntity.InputStreamEntity)httpEntity;
            InputStream stream = inputStreamEntity.content();
            Option contentType = inputStreamEntity.contentCharset();
            ContentType ct = (ContentType)contentType.flatMap((Function1 & Serializable)value -> ContentType$.MODULE$.parse(value).right().toOption()).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.application$divoctet$minusstream());
            strict = HttpEntity$.MODULE$.apply(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> stream, StreamConverters$.MODULE$.fromInputStream$default$2()));
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return strict;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$queue$6(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Try try_ = (Try)tuple2._1();
            RequestState s = (RequestState)tuple2._2();
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                HttpResponse resp = (HttpResponse)success.value();
                s.response().success((Object)resp);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Try try_ = (Try)tuple2._1();
        RequestState s = (RequestState)tuple2._2();
        if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        s.response().failure(e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public final Future com$sksamuel$elastic4s$akka$AkkaHttpClient$$retryIfPossible$1(Function0 notPossible, long startTimeNanos$1, ElasticRequest request$1) {
        Future future;
        long timePassed = System.nanoTime() - startTimeNanos$1;
        if (timePassed < this.settings.maxRetryTimeout().toNanos()) {
            this.logger().trace(new StringBuilder(20).append("Retrying a request: ").append(request$1.endpoint()).toString());
            future = this.queueRequestWithRetry(request$1, startTimeNanos$1);
        } else {
            Future future2;
            Either either = (Either)notPossible.apply();
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable exc = (Throwable)left.value();
                future2 = Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(45).append("Request retries exceeded max retry timeout [").append(this.settings.maxRetryTimeout()).append("]").toString(), exc));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                HttpResponse resp = (HttpResponse)right.value();
                future2 = Future$.MODULE$.successful((Object)resp);
            } else {
                throw new MatchError((Object)either);
            }
            future = future2;
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$queueRequestWithRetry$1(AkkaHttpClient $this, String host) {
        if ($this.blacklist.add(host)) {
            $this.logger().debug(new StringBuilder(21).append("added [").append(host).append("] to blacklist").toString());
        } else {
            $this.logger().trace(new StringBuilder(25).append("updated [").append(host).append("] in a blacklist").toString());
        }
    }

    public final Future com$sksamuel$elastic4s$akka$AkkaHttpClient$$markDead$1(RequestState state$2) {
        return state$2.host().future().map((Function1 & Serializable)host -> {
            AkkaHttpClient.$anonfun$queueRequestWithRetry$1(this, host);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$queueRequestWithRetry$2(AkkaHttpClient $this, String host) {
        block0: {
            if (!$this.blacklist.remove(host)) break block0;
            $this.logger().debug(new StringBuilder(25).append("removed [").append(host).append("] from blacklist").toString());
        }
    }

    private final Future markAlive$1(RequestState state$2) {
        return state$2.host().future().map((Function1 & Serializable)host -> {
            AkkaHttpClient.$anonfun$queueRequestWithRetry$2(this, host);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$send$1(Function1 callback$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse r = (HttpResponse)success.value();
            BoxedUnit boxedUnit = (BoxedUnit)callback$1.apply((Object)package$.MODULE$.Right().apply((Object)r));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            BoxedUnit boxedUnit = (BoxedUnit)callback$1.apply((Object)package$.MODULE$.Left().apply((Object)e));
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public AkkaHttpClient(AkkaHttpClientSettings settings, Blacklist blacklist, HttpPoolFactory httpPoolFactory, ActorSystem system) {
        this.settings = settings;
        this.blacklist = blacklist;
        this.httpPoolFactory = httpPoolFactory;
        this.com$sksamuel$elastic4s$akka$AkkaHttpClient$$system = system;
        HttpClient.$init$((HttpClient)this);
        this.materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.scheme = settings.https() ? "https" : "http";
        this.queue = (SourceQueueWithComplete)((Source)((Source)Source$.MODULE$.queue(settings.queueSize(), OverflowStrategy$.MODULE$.backpressure()).statefulMapConcat((Function0 & Serializable)() -> {
            Iterator<Option<String>> hosts = this.iterateHosts();
            return (Function1 & Serializable)in -> {
                Tuple2 tuple2 = new Tuple2(in, hosts.next());
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (tuple22 != null) {
                        ElasticRequest r = (ElasticRequest)tuple22._1();
                        RequestState s = (RequestState)tuple22._2();
                        if (option instanceof Some) {
                            List list;
                            Some some = (Some)option;
                            String host = (String)some.value();
                            Try<HttpRequest> try_ = this.toRequest(r, host);
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                HttpRequest req = (HttpRequest)success.value();
                                s.host().success((Object)host);
                                Tuple2 tuple23 = new Tuple2((Object)req, (Object)s);
                                list = package$.MODULE$.Nil().$colon$colon((Object)tuple23);
                                return list;
                            } else {
                                if (!(try_ instanceof Failure)) throw new MatchError(try_);
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                s.host().failure(e);
                                s.response().failure(e);
                                list = package$.MODULE$.Nil();
                            }
                            return list;
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                Option option = (Option)tuple2._2();
                if (tuple24 == null) throw new MatchError((Object)tuple2);
                RequestState s = (RequestState)tuple24._2();
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                AkkaHttpClient$AllHostsBlacklistedException$ exception = AkkaHttpClient$AllHostsBlacklistedException$.MODULE$;
                s.host().failure((Throwable)exception);
                s.response().failure((Throwable)exception);
                return package$.MODULE$.Nil();
            };
        })).via(httpPoolFactory.create()).flatMapMerge(settings.poolSettings().maxConnections(), (Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                HttpRequest request = (HttpRequest)tuple3._1();
                Try try_ = (Try)tuple3._2();
                RequestState state = (RequestState)tuple3._3();
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    akka.http.scaladsl.model.HttpResponse response = (akka.http.scaladsl.model.HttpResponse)success.value();
                    HttpMethod httpMethod = request.method();
                    HttpMethod httpMethod2 = HttpMethods$.MODULE$.HEAD();
                    if (!(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null)) {
                        HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), this.materializer());
                        return Source$.MODULE$.single((Object)new Tuple2((Object)new Success((Object)this.toResponse(response, ByteString$.MODULE$.empty())), (Object)state));
                    }
                }
            }
            if (tuple3 != null) {
                Try try_ = (Try)tuple3._2();
                RequestState s = (RequestState)tuple3._3();
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    akka.http.scaladsl.model.HttpResponse r = (akka.http.scaladsl.model.HttpResponse)success.value();
                    return (Source)r.entity().dataBytes().fold((Object)ByteString$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x$1, x$2) -> x$1.$plus$plus(x$2)).map((Function1 & Serializable)data -> new Tuple2((Object)new Success((Object)this.toResponse(r, (ByteString)data)), (Object)s)).recoverWithRetries(1, (PartialFunction)new Serializable(null, s){
                        private static final long serialVersionUID = 0L;
                        private final RequestState s$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                object = Source$.MODULE$.single((Object)new Tuple2((Object)new Failure(A12), (Object)this.s$1));
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable != null;
                            return bl;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                }
            }
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            Try try_ = (Try)tuple3._2();
            RequestState s = (RequestState)tuple3._3();
            if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple3);
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return Source$.MODULE$.single((Object)new Tuple2((Object)new Failure(e), (Object)s));
        })).toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)x0$2 -> {
            AkkaHttpClient.$anonfun$queue$6(x0$2);
            return BoxedUnit.UNIT;
        }), Keep$.MODULE$.left()).run(this.materializer());
        Statics.releaseFence();
    }

    public static class RequestState
    implements Product,
    Serializable {
        private final Promise<HttpResponse> response;
        private final Promise<String> host;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Promise<HttpResponse> response() {
            return this.response;
        }

        public Promise<String> host() {
            return this.host;
        }

        public RequestState copy(Promise<HttpResponse> response, Promise<String> host) {
            return new RequestState(response, host);
        }

        public Promise<HttpResponse> copy$default$1() {
            return this.response();
        }

        public Promise<String> copy$default$2() {
            return this.host();
        }

        public String productPrefix() {
            return "RequestState";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.response();
                    break;
                }
                case 1: {
                    object = this.host();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequestState;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "response";
                    break;
                }
                case 1: {
                    string = "host";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequestState)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequestState requestState = (RequestState)x$1;
            Promise<HttpResponse> promise = this.response();
            Promise<HttpResponse> promise2 = requestState.response();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Promise<String> promise3 = this.host();
            Promise<String> promise4 = requestState.host();
            if (promise3 == null) {
                if (promise4 != null) {
                    return false;
                }
            } else if (!promise3.equals(promise4)) return false;
            if (!requestState.canEqual(this)) return false;
            return true;
        }

        public RequestState(Promise<HttpResponse> response, Promise<String> host) {
            this.response = response;
            this.host = host;
            Product.$init$((Product)this);
        }
    }
}

