/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import com.sksamuel.elastic4s.ElasticProperties;
import com.sksamuel.elastic4s.ElasticRequest;
import com.sksamuel.elastic4s.ElasticRequest$;
import com.sksamuel.elastic4s.HttpClient;
import com.sksamuel.elastic4s.HttpEntity;
import com.sksamuel.elastic4s.HttpResponse;
import com.sksamuel.elastic4s.HttpResponse$;
import com.sksamuel.elastic4s.Show$;
import com.sksamuel.elastic4s.http.JavaClient$;
import com.sksamuel.elastic4s.http.JavaClientExceptionWrapper$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class JavaClient
implements HttpClient {
    private Logger logger;
    private final RestClient client;

    public static JavaClient apply(ElasticProperties elasticProperties) {
        return JavaClient$.MODULE$.apply(elasticProperties);
    }

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, httpClientConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.RequestConfigCallback requestConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, requestConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.RequestConfigCallback requestConfigCallback, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, requestConfigCallback, httpClientConfigCallback);
    }

    public static JavaClient fromRestClient(RestClient restClient) {
        return JavaClient$.MODULE$.fromRestClient(restClient);
    }

    public JavaClient(RestClient client) {
        this.client = client;
        HttpClient.$init$((HttpClient)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$sksamuel$elastic4s$HttpClient$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public AbstractHttpEntity apacheEntity(HttpEntity entity) {
        ByteArrayEntity byteArrayEntity;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.StringEntity) {
            HttpEntity.StringEntity e = (HttpEntity.StringEntity)httpEntity;
            this.logger().debug(e.content());
            byteArrayEntity = new StringEntity(e.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.ByteArrayEntity) {
            HttpEntity.ByteArrayEntity e = (HttpEntity.ByteArrayEntity)httpEntity;
            byteArrayEntity = new ByteArrayEntity(e.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.InputStreamEntity) {
            HttpEntity.InputStreamEntity e = (HttpEntity.InputStreamEntity)httpEntity;
            this.logger().debug(e.content().toString());
            byteArrayEntity = new InputStreamEntity(e.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.FileEntity) {
            HttpEntity.FileEntity e = (HttpEntity.FileEntity)httpEntity;
            this.logger().debug(e.content().toString());
            byteArrayEntity = new FileEntity(e.content(), ContentType.APPLICATION_JSON);
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return (AbstractHttpEntity)byteArrayEntity;
    }

    public HttpResponse fromResponse(Response r) {
        Option entity2 = Option$.MODULE$.apply((Object)r.getEntity()).map((Function1 & Serializable)entity -> {
            Charset contentCharset = (Charset)Option$.MODULE$.apply(Option$.MODULE$.apply((Object)ContentType.get((org.apache.http.HttpEntity)entity)).fold(JavaClient::$anonfun$2, (Function1 & Serializable)_$1 -> _$1.getCharset())).getOrElse(JavaClient::$anonfun$4);
            Codec codec = Codec$.MODULE$.apply(contentCharset);
            InputStream contentStream = this.isEntityGziped((org.apache.http.HttpEntity)entity) ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            String body = Source$.MODULE$.fromInputStream(contentStream, codec).mkString();
            return HttpEntity.StringEntity$.MODULE$.apply(body, (Option)Some$.MODULE$.apply((Object)contentCharset.name()));
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])r.getHeaders());
        Map headers = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)header -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)header.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)header.getValue());
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logger().debug("Http Response {}", (Object)r);
        return HttpResponse$.MODULE$.apply(r.getStatusLine().getStatusCode(), entity2, headers);
    }

    public void send(ElasticRequest req, Function1<Either<Throwable, HttpResponse>, BoxedUnit> callback) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Executing elastic request {}", (Object)Show$.MODULE$.apply(ElasticRequest$.MODULE$.ElasticRequestShow()).show((Object)req));
        }
        ResponseListener l = new ResponseListener(callback, this){
            private final Function1 callback$1;
            private final /* synthetic */ JavaClient $outer;
            {
                this.callback$1 = callback$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onSuccess(Response r) {
                this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(r)));
            }

            public void onFailure(Exception e) {
                Exception exception = e;
                if (exception instanceof ResponseException) {
                    ResponseException re = (ResponseException)exception;
                    this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(re.getResponse())));
                    return;
                }
                Exception t = exception;
                this.callback$1.apply((Object)package$.MODULE$.Left().apply((Object)JavaClientExceptionWrapper$.MODULE$.apply(t)));
            }
        };
        Request request = new Request(req.method(), req.endpoint());
        req.params().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                request.addParameter(key, value);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        req.entity().map((Function1 & Serializable)entity -> this.apacheEntity((HttpEntity)entity)).foreach((Function1)(JProcedure1 & Serializable)x$0 -> request.setEntity(x$0));
        RequestOptions.Builder optBuilder = request.getOptions().toBuilder();
        req.headers().foreach(((Function2 & Serializable)(Function2 & Serializable)(x$0, x$1) -> optBuilder.addHeader(x$0, x$1)).tupled());
        request.setOptions(optBuilder);
        this.client.performRequestAsync(request, l);
    }

    public void close() {
        this.client.close();
    }

    private boolean isEntityGziped(org.apache.http.HttpEntity entity) {
        return Option$.MODULE$.apply((Object)entity.getContentEncoding()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getValue())).contains((Object)"gzip");
    }

    private static final Charset $anonfun$2() {
        return StandardCharsets.UTF_8;
    }

    private static final Charset $anonfun$4() {
        return StandardCharsets.UTF_8;
    }
}

