/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.concurrent;

import com.sksamuel.exts.Logging;
import com.sksamuel.exts.Logging$class;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.IntUnaryOperator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\tIA\u000b\u001b:piRdWM\u001d\u0006\u0003\u0007\u0011\t!bY8oGV\u0014(/\u001a8u\u0015\t)a!\u0001\u0003fqR\u001c(BA\u0004\t\u0003!\u00198n]1nk\u0016d'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u001d\u0019w.\u001e8uKJ\u0004\"!G\u0011\u000e\u0003iQ!a\u0007\u000f\u0002\r\u0005$x.\\5d\u0015\t\u0019QD\u0003\u0002\u001f?\u0005!Q\u000f^5m\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!A\t\u000e\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001\u00027pG.\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u000f\u0002\u000b1|7m[:\n\u0005):#\u0001\u0002'pG.D\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\fSN,\u00050Z2vi&tw\r\u0005\u0002']%\u0011qf\n\u0002\n\u0007>tG-\u001b;j_:DQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a6m]\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQa\u0006\u0019A\u0002aAQ\u0001\n\u0019A\u0002\u0015BQ\u0001\f\u0019A\u00025BQ!\u000f\u0001\u0005\u0002i\nA\u0001Z8x]R\t1\b\u0005\u0002\u000ey%\u0011QH\u0004\u0002\u0005+:LG\u000fC\u0003@\u0001\u0011\u0005!(\u0001\u0002va\")\u0011\t\u0001C\u0001\u0005\u0006)\u0011\r\u001d9msV\u00111I\u0012\u000b\u0003\t>\u0003\"!\u0012$\r\u0001\u0011)q\t\u0011b\u0001\u0011\n\tA+\u0005\u0002J\u0019B\u0011QBS\u0005\u0003\u0017:\u0011qAT8uQ&tw\r\u0005\u0002\u000e\u001b&\u0011aJ\u0004\u0002\u0004\u0003:L\bB\u0002)A\t\u0003\u0007\u0011+\u0001\u0002g]B\u0019QB\u0015#\n\u0005Ms!\u0001\u0003\u001fcs:\fW.\u001a ")
public class Throttler
implements Logging {
    private final AtomicInteger counter;
    private final Lock lock;
    private final Condition isExecuting;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void down() {
        if (this.counter.updateAndGet(new IntUnaryOperator(this){

            public int applyAsInt(int operand) {
                return operand - 1;
            }
        }) == 0) {
            this.lock.lock();
            this.isExecuting.signalAll();
            this.lock.unlock();
        }
    }

    public void up() {
        this.counter.updateAndGet(new IntUnaryOperator(this){

            public int applyAsInt(int operand) {
                return operand + 1;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T apply(Function0<T> fn) {
        while (this.counter.get() > 0) {
            try {
                this.logger().debug("Throttling...");
                this.lock.lock();
                this.isExecuting.await();
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InterruptedException) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logger().error("Error while throttling", e);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            break;
        }
        return (T)fn.apply();
    }

    public Throttler(AtomicInteger counter, Lock lock, Condition isExecuting) {
        this.counter = counter;
        this.lock = lock;
        this.isExecuting = isExecuting;
        Logging$class.$init$(this);
    }
}

