/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.config;

import com.sksamuel.exts.Logging;
import com.sksamuel.exts.Logging$class;
import com.sksamuel.exts.OptionImplicits$;
import com.sksamuel.exts.config.ConfigLoaderParams;
import com.sksamuel.exts.config.ConfigLoaderParams$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.sys.package$;

public final class ConfigLoader$
implements Logging {
    public static final ConfigLoader$ MODULE$;
    private final String ConfigKey;
    private final String LocalEnv;
    private final Logger logger;

    static {
        new ConfigLoader$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String ConfigKey() {
        return this.ConfigKey;
    }

    public String LocalEnv() {
        return this.LocalEnv;
    }

    public Config load(ConfigLoaderParams params) {
        String env = (String)Option$.MODULE$.apply(package$.MODULE$.props().apply((Object)this.ConfigKey())).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)ConfigLoader$.MODULE$.ConfigKey());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigLoader$.MODULE$.LocalEnv();
            }
        });
        String resolvedEnvConfFilename = params.envConfFilename().replace("$ENV", env);
        String userHome = System.getProperty("user.home");
        Config refconf = ConfigFactory.defaultReference();
        Config appconf = ConfigFactory.parseResources((String)params.applicationConfName());
        Config envconf = this.envConf$1(params, resolvedEnvConfFilename, userHome);
        Config overrideconf = this.overrideConf$1(params, userHome);
        return overrideconf.withFallback((ConfigMergeable)envconf).withFallback((ConfigMergeable)appconf).withFallback((ConfigMergeable)refconf).resolve();
    }

    public ConfigLoaderParams load$default$1() {
        return new ConfigLoaderParams(ConfigLoaderParams$.MODULE$.apply$default$1(), ConfigLoaderParams$.MODULE$.apply$default$2(), ConfigLoaderParams$.MODULE$.apply$default$3(), ConfigLoaderParams$.MODULE$.apply$default$4(), ConfigLoaderParams$.MODULE$.apply$default$5(), ConfigLoaderParams$.MODULE$.apply$default$6(), ConfigLoaderParams$.MODULE$.apply$default$7(), ConfigLoaderParams$.MODULE$.apply$default$8(), ConfigLoaderParams$.MODULE$.apply$default$9());
    }

    public Config apply(String appName) {
        String env = (String)Option$.MODULE$.apply(package$.MODULE$.props().apply((Object)this.ConfigKey())).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)ConfigLoader$.MODULE$.ConfigKey());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigLoader$.MODULE$.LocalEnv();
            }
        });
        Config refConf = ConfigFactory.defaultReference();
        Config appConf = ConfigFactory.parseResources((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appName})));
        Config envConf = this.locateAndLoadEnvConf$1(env);
        Config overConf = this.locateAndLoadOverrideConf$1("override.conf");
        return overConf.withFallback((ConfigMergeable)envConf).withFallback((ConfigMergeable)appConf).withFallback((ConfigMergeable)refConf).resolve();
    }

    public String apply$default$1() {
        return "application";
    }

    private final Config loadPath$1(Path path) {
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path.toAbsolutePath()).some().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Path path) {
                ConfigLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading path:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                return ConfigFactory.parseFile((File)path.toFile());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply() {
                return ConfigFactory.empty();
            }
        });
    }

    private final Config loadResource$1(String resource) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading classpath:", " (if present)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource})));
        return ConfigFactory.parseResources((String)resource);
    }

    private final Config loadOverrideFromDir$1(String path, ConfigLoaderParams params$1) {
        return this.loadPath$1(Paths.get(path, new String[0]).resolve(params$1.overrideConfName()));
    }

    private final Config overrideConf$1(ConfigLoaderParams params$1, String userHome$1) {
        Config workingDirConf = params$1.overrideConfInWorkingDir() ? this.loadOverrideFromDir$1(".", params$1) : ConfigFactory.empty();
        Config userHomeConf = params$1.overrideConfInUserHome() ? this.loadOverrideFromDir$1(userHome$1, params$1) : ConfigFactory.empty();
        return workingDirConf.withFallback((ConfigMergeable)userHomeConf);
    }

    private final Config loadEnvConfFromDir$1(String path, String resolvedEnvConfFilename$1) {
        return this.loadPath$1(Paths.get(path, new String[0]).resolve(resolvedEnvConfFilename$1));
    }

    private final Config envConf$1(ConfigLoaderParams params$1, String resolvedEnvConfFilename$1, String userHome$1) {
        Config workingDirConf = params$1.envConfInWorkingDir() ? this.loadEnvConfFromDir$1(".", resolvedEnvConfFilename$1) : ConfigFactory.empty();
        Config userHomeConf = params$1.envConfInUserHome() ? this.loadEnvConfFromDir$1(userHome$1, resolvedEnvConfFilename$1) : ConfigFactory.empty();
        Config classpathConf = this.loadResource$1(resolvedEnvConfFilename$1);
        return workingDirConf.withFallback((ConfigMergeable)userHomeConf).withFallback((ConfigMergeable)classpathConf);
    }

    private final Config locateAndLoadOverrideConf$1(String name) {
        Path overrideConfPath = Paths.get(".", new String[0]).resolve(name).toAbsolutePath();
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(overrideConfPath).some().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Path path) {
                ConfigLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading OVERRIDE:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                return ConfigFactory.parseFile((File)path.toFile());
            }
        }).getOrElse((Function0)new Serializable(overrideConfPath){
            public static final long serialVersionUID = 0L;
            private final Path overrideConfPath$1;

            public final Config apply() {
                ConfigLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No override conf located at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.overrideConfPath$1})));
                return ConfigFactory.empty();
            }
            {
                this.overrideConfPath$1 = overrideConfPath$1;
            }
        });
    }

    private final Config locateAndLoadEnvConf$1(String env) {
        String confFilename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{env}));
        Option<Path> cwdConfFile = OptionImplicits$.MODULE$.RichPathOptionImplicits(Paths.get(".", new String[0]).resolve(confFilename).toAbsolutePath()).some();
        Option<Path> homeFolderConfFile = OptionImplicits$.MODULE$.RichPathOptionImplicits(Paths.get((String)package$.MODULE$.props().apply((Object)"user.home"), new String[0]).resolve(confFilename).toAbsolutePath()).some();
        return (Config)cwdConfFile.orElse((Function0)new Serializable(homeFolderConfFile){
            public static final long serialVersionUID = 0L;
            private final Option homeFolderConfFile$1;

            public final Option<Path> apply() {
                return this.homeFolderConfFile$1;
            }
            {
                this.homeFolderConfFile$1 = homeFolderConfFile$1;
            }
        }).map((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final String env$1;

            public final Config apply(Path path) {
                ConfigLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ENV:", " config from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.env$1, path})));
                return ConfigFactory.parseFile((File)path.toFile());
            }
            {
                this.env$1 = env$1;
            }
        }).getOrElse((Function0)new Serializable(env, confFilename){
            public static final long serialVersionUID = 0L;
            private final String env$1;
            private final String confFilename$1;

            public final Config apply() {
                ConfigLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ENV:", " config from classpath (if present)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.env$1})));
                return ConfigFactory.parseResources((String)this.confFilename$1);
            }
            {
                this.env$1 = env$1;
                this.confFilename$1 = confFilename$1;
            }
        });
    }

    private ConfigLoader$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConfigKey = "CONFIG_ENV";
        this.LocalEnv = "LOCAL";
    }
}

