/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.hocon;

import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.NumberNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.hocon.HoconParserKt;
import com.sksamuel.hoplite.hocon.ListProduction;
import com.sksamuel.hoplite.hocon.MapProduction;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lcom/sksamuel/hoplite/hocon/ValueProduction;", "", "()V", "invoke", "Lcom/sksamuel/hoplite/Node;", "value", "Lcom/typesafe/config/ConfigValue;", "source", "", "hoplite-hocon"})
public final class ValueProduction {
    @NotNull
    public static final ValueProduction INSTANCE = new ValueProduction();

    private ValueProduction() {
    }

    @NotNull
    public final Node invoke(@NotNull ConfigValue value, @NotNull String source) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ConfigValueType configValueType = value.valueType();
        int n = configValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configValueType.ordinal()];
        switch (n) {
            case 1: {
                ConfigObject configObject = (ConfigObject)value;
                ConfigOrigin configOrigin = value.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                node = MapProduction.INSTANCE.invoke(configObject, configOrigin, source);
                break;
            }
            case 2: {
                NumberNode numberNode;
                Object v = value.unwrapped();
                if (v instanceof Double) {
                    double d = ((Number)v).doubleValue();
                    ConfigOrigin configOrigin = value.origin();
                    Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                    numberNode = (NumberNode)new DoubleNode(d, HoconParserKt.toPos(configOrigin, source));
                } else if (v instanceof Float) {
                    double d = ((Number)v).floatValue();
                    ConfigOrigin configOrigin = value.origin();
                    Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                    numberNode = (NumberNode)new DoubleNode(d, HoconParserKt.toPos(configOrigin, source));
                } else if (v instanceof Long) {
                    long l = ((Number)v).longValue();
                    ConfigOrigin configOrigin = value.origin();
                    Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                    numberNode = (NumberNode)new LongNode(l, HoconParserKt.toPos(configOrigin, source));
                } else if (v instanceof Integer) {
                    long l = ((Number)v).intValue();
                    ConfigOrigin configOrigin = value.origin();
                    Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                    numberNode = (NumberNode)new LongNode(l, HoconParserKt.toPos(configOrigin, source));
                } else {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected element type for ConfigValueType.NUMBER: ", (Object)v));
                }
                node = (Node)numberNode;
                break;
            }
            case 3: {
                ConfigList configList = (ConfigList)value;
                ConfigOrigin v = value.origin();
                Intrinsics.checkNotNullExpressionValue((Object)v, (String)"value.origin()");
                node = (Node)ListProduction.INSTANCE.invoke(configList, v, source);
                break;
            }
            case 4: {
                Object v = value.unwrapped();
                if (!(v instanceof Boolean)) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected element type for ConfigValueType.BOOLEAN: ", (Object)v));
                }
                boolean bl = (Boolean)v;
                ConfigOrigin configOrigin = value.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                node = (Node)new BooleanNode(bl, HoconParserKt.toPos(configOrigin, source));
                break;
            }
            case 5: {
                String string = value.unwrapped().toString();
                ConfigOrigin configOrigin = value.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                node = (Node)new StringNode(string, HoconParserKt.toPos(configOrigin, source));
                break;
            }
            case 6: {
                ConfigOrigin configOrigin = value.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"value.origin()");
                node = (Node)new NullNode(HoconParserKt.toPos(configOrigin, source));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return node;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigValueType.values().length];
            nArray[ConfigValueType.OBJECT.ordinal()] = 1;
            nArray[ConfigValueType.NUMBER.ordinal()] = 2;
            nArray[ConfigValueType.LIST.ordinal()] = 3;
            nArray[ConfigValueType.BOOLEAN.ordinal()] = 4;
            nArray[ConfigValueType.STRING.ordinal()] = 5;
            nArray[ConfigValueType.NULL.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

