/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.json.ArrayProduction;
import com.sksamuel.hoplite.json.JsonKt;
import com.sksamuel.hoplite.json.ObjectProduction;
import com.sksamuel.hoplite.json.TokenProduction$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lcom/sksamuel/hoplite/json/TokenProduction;", "", "()V", "invoke", "Lcom/sksamuel/hoplite/Node;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "source", "", "hoplite-json"})
public final class TokenProduction {
    public static final TokenProduction INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Node invoke(@NotNull JsonParser parser, @NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        JsonToken jsonToken = parser.currentToken();
        if (jsonToken == null) throw (Throwable)new UnsupportedOperationException("Invalid json at " + parser.getCurrentLocation() + "; encountered unexpected token " + parser.getCurrentToken());
        switch (TokenProduction$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
            case 1: {
                throw (Throwable)new UnsupportedOperationException("Invalid json at " + parser.getCurrentLocation());
            }
            case 2: {
                Node node = ObjectProduction.INSTANCE.invoke(parser, source);
                return node;
            }
            case 3: {
                Node node = ArrayProduction.INSTANCE.invoke(parser, source);
                return node;
            }
            case 4: {
                String string = parser.getValueAsString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.valueAsString");
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new StringNode(string, JsonKt.toPos(jsonLocation, source));
                return node;
            }
            case 5: {
                long l = parser.getValueAsLong();
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new LongNode(l, JsonKt.toPos(jsonLocation, source));
                return node;
            }
            case 6: {
                double d = parser.getValueAsDouble();
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new DoubleNode(d, JsonKt.toPos(jsonLocation, source));
                return node;
            }
            case 7: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new BooleanNode(true, JsonKt.toPos(jsonLocation, source));
                return node;
            }
            case 8: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new BooleanNode(false, JsonKt.toPos(jsonLocation, source));
                return node;
            }
            case 9: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"parser.currentLocation");
                Node node = (Node)new NullNode(JsonKt.toPos(jsonLocation, source));
                return node;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Invalid json at " + parser.getCurrentLocation() + "; encountered unexpected token " + parser.getCurrentToken());
            }
        }
    }

    private TokenProduction() {
    }

    static {
        TokenProduction tokenProduction;
        INSTANCE = tokenProduction = new TokenProduction();
    }
}

