/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.json.ArrayProduction;
import com.sksamuel.hoplite.json.JsonKt;
import com.sksamuel.hoplite.json.ObjectProduction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lcom/sksamuel/hoplite/json/TokenProduction;", "", "()V", "invoke", "Lcom/sksamuel/hoplite/Node;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "source", "", "hoplite-json"})
public final class TokenProduction {
    @NotNull
    public static final TokenProduction INSTANCE = new TokenProduction();

    private TokenProduction() {
    }

    @NotNull
    public final Node invoke(@NotNull JsonParser parser, @NotNull String source) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        JsonToken jsonToken = parser.currentToken();
        int n = jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()];
        switch (n) {
            case 1: {
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Invalid json at ", (Object)parser.getCurrentLocation()));
            }
            case 2: {
                node = ObjectProduction.INSTANCE.invoke(parser, source);
                break;
            }
            case 3: {
                node = ArrayProduction.INSTANCE.invoke(parser, source);
                break;
            }
            case 4: {
                String string = parser.getValueAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.valueAsString");
                String string2 = string;
                string = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.currentLocation");
                node = (Node)new StringNode(string2, JsonKt.toPos((JsonLocation)string, source));
                break;
            }
            case 5: {
                long l = parser.getValueAsLong();
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)jsonLocation, (String)"parser.currentLocation");
                node = (Node)new LongNode(l, JsonKt.toPos(jsonLocation, source));
                break;
            }
            case 6: {
                double d = parser.getValueAsDouble();
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)jsonLocation, (String)"parser.currentLocation");
                node = (Node)new DoubleNode(d, JsonKt.toPos(jsonLocation, source));
                break;
            }
            case 7: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)jsonLocation, (String)"parser.currentLocation");
                node = (Node)new BooleanNode(true, JsonKt.toPos(jsonLocation, source));
                break;
            }
            case 8: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)jsonLocation, (String)"parser.currentLocation");
                node = (Node)new BooleanNode(false, JsonKt.toPos(jsonLocation, source));
                break;
            }
            case 9: {
                JsonLocation jsonLocation = parser.getCurrentLocation();
                Intrinsics.checkNotNullExpressionValue((Object)jsonLocation, (String)"parser.currentLocation");
                node = (Node)new NullNode(JsonKt.toPos(jsonLocation, source));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid json at " + parser.getCurrentLocation() + "; encountered unexpected token " + parser.getCurrentToken());
            }
        }
        return node;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            nArray[JsonToken.NOT_AVAILABLE.ordinal()] = 1;
            nArray[JsonToken.START_OBJECT.ordinal()] = 2;
            nArray[JsonToken.START_ARRAY.ordinal()] = 3;
            nArray[JsonToken.VALUE_STRING.ordinal()] = 4;
            nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 5;
            nArray[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 6;
            nArray[JsonToken.VALUE_TRUE.ordinal()] = 7;
            nArray[JsonToken.VALUE_FALSE.ordinal()] = 8;
            nArray[JsonToken.VALUE_NULL.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

