/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scapegoat.io;

import com.sksamuel.scapegoat.Feedback;
import com.sksamuel.scapegoat.Levels$Error$;
import com.sksamuel.scapegoat.Levels$Info$;
import com.sksamuel.scapegoat.Levels$Warning$;
import com.sksamuel.scapegoat.Warning;
import com.sksamuel.scapegoat.io.ReportWriter;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;

public final class MarkdownReportWriter$
implements ReportWriter {
    public static final MarkdownReportWriter$ MODULE$ = new MarkdownReportWriter$();

    static {
        ReportWriter.$init$(MODULE$);
    }

    @Override
    public File write(File targetDir, Feedback feedback) {
        return ReportWriter.write$(this, targetDir, feedback);
    }

    @Override
    public String fileName() {
        return "scapegoat.md";
    }

    @Override
    public String generate(Feedback reporter) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(168).append("# Scapegoat Inspections\n       |\n       |**Errors**: ").append(Integer.toString(reporter.warnings(Levels$Error$.MODULE$).size())).append("\n       |\n       |**Warnings**: ").append(Integer.toString(reporter.warnings(Levels$Warning$.MODULE$).size())).append("\n       |\n       |**Infos**: ").append(Integer.toString(reporter.warnings(Levels$Info$.MODULE$).size())).append("\n       |\n       |## Report\n       |\n       |").append(this.renderAll(reporter)).append("\n       |").toString()));
    }

    private String renderAll(Feedback reporter) {
        return ((IterableOnceOps)reporter.warningsWithMinimalLevel().map((Function1 & Serializable)warning -> MODULE$.renderWarning((Warning)warning))).mkString("\n");
    }

    private String renderWarning(Warning warning) {
        String source = new StringBuilder(1).append(warning.sourceFileNormalized()).append(":").append(warning.line()).toString();
        String md = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(152).append("### ").append(source).append("\n         |\n         |**Level**: ").append(warning.level().toString()).append("\n         |\n         |**Inspection**: ").append(warning.inspection()).append("\n         |\n         |").append(warning.text()).append("\n         |\n         |").append(warning.explanation()).append("\n         |\n         |").append(warning.snippet().map((Function1 & Serializable)snippet -> new StringBuilder(14).append("\n```scala\n").append((String)snippet).append("\n```").toString()).getOrElse((Function0 & Serializable)() -> "")).append("\n         |").toString()));
        return md;
    }

    private MarkdownReportWriter$() {
    }
}

