/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scapegoat.io;

import com.sksamuel.scapegoat.Feedback;
import com.sksamuel.scapegoat.Level;
import com.sksamuel.scapegoat.Levels$Error$;
import com.sksamuel.scapegoat.Levels$Info$;
import com.sksamuel.scapegoat.Levels$Warning$;
import com.sksamuel.scapegoat.Warning;
import com.sksamuel.scapegoat.io.CodeQualityReportElement;
import com.sksamuel.scapegoat.io.CriticalSeverity$;
import com.sksamuel.scapegoat.io.InfoSeverity$;
import com.sksamuel.scapegoat.io.Lines;
import com.sksamuel.scapegoat.io.Location;
import com.sksamuel.scapegoat.io.MinorSeverity$;
import com.sksamuel.scapegoat.io.ReportWriter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class GitlabCodeQualityReportWriter$
implements ReportWriter {
    public static final GitlabCodeQualityReportWriter$ MODULE$ = new GitlabCodeQualityReportWriter$();

    static {
        ReportWriter.$init$(MODULE$);
    }

    @Override
    public File write(File targetDir, Feedback<?> feedback) {
        return ReportWriter.write$(this, targetDir, feedback);
    }

    @Override
    public String fileName() {
        return "scapegoat-gitlab.json";
    }

    @Override
    public String generate(Feedback<?> feedback) {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        return ((IterableOnceOps)this.toCodeQualityElements(feedback.warningsWithMinimalLevel(), (Option<String>)package$.MODULE$.env().get((Object)"CI_PROJECT_DIR"), md5Digest).map((Function1 & Serializable)x$1 -> x$1.toJsonArrayElement())).mkString("[", ",", "]");
    }

    public Seq<CodeQualityReportElement> toCodeQualityElements(Seq<Warning> warnings, Option<String> gitlabBuildDir, MessageDigest messageDigest) {
        return (Seq)warnings.map((Function1 & Serializable)warning -> {
            String fingerprintRaw = new StringBuilder(0).append(warning.sourceFileNormalized()).append(warning.snippet().getOrElse((Function0 & Serializable)() -> Integer.toString(warning.line()))).toString();
            messageDigest.reset();
            messageDigest.update(fingerprintRaw.getBytes(StandardCharsets.UTF_8));
            String fingerprint = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(messageDigest.digest()), (Function1 & Serializable)x$2 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$2))})), ClassTag$.MODULE$.apply(String.class))).mkString();
            Level level = warning.level();
            CriticalSeverity$ severity = Levels$Error$.MODULE$.equals(level) ? CriticalSeverity$.MODULE$ : (Levels$Warning$.MODULE$.equals(level) ? MinorSeverity$.MODULE$ : (Levels$Info$.MODULE$.equals(level) ? InfoSeverity$.MODULE$ : InfoSeverity$.MODULE$));
            String gitlabCiNormalizedPath = (String)gitlabBuildDir.map((Function1 & Serializable)buildDir -> {
                String fullBuildDir = buildDir.endsWith("/") ? buildDir : new StringBuilder(1).append((String)buildDir).append("/").toString();
                String file = warning.sourceFileFull();
                if (file.startsWith(fullBuildDir)) {
                    return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(file), fullBuildDir.length());
                }
                return file;
            }).getOrElse((Function0 & Serializable)() -> warning.sourceFileFull());
            String textStart = warning.explanation().startsWith(warning.text()) ? "" : (warning.text().endsWith(".") ? new StringBuilder(1).append(warning.text()).append(" ").toString() : new StringBuilder(2).append(warning.text()).append(". ").toString());
            String description = new StringBuilder(0).append(textStart).append(warning.explanation()).toString();
            return new CodeQualityReportElement(description, warning.inspection(), severity, new Location(gitlabCiNormalizedPath, new Lines(warning.line())), fingerprint);
        });
    }

    private GitlabCodeQualityReportWriter$() {
    }
}

