/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.webp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;

abstract class WebpHandler {
    WebpHandler() {
    }

    protected static Path createPlaceholder(String name) throws IOException {
        return Files.createTempFile(name, "binary", new FileAttribute[0]);
    }

    protected static void installBinary(Path output, String ... sources) throws IOException {
        for (String source : sources) {
            InputStream in = WebpHandler.class.getResourceAsStream(source);
            if (in == null) continue;
            Files.copy(in, output, StandardCopyOption.REPLACE_EXISTING);
            in.close();
            if (!SystemUtils.IS_OS_WINDOWS) {
                WebpHandler.setExecutable(output);
            }
            return;
        }
        throw new IOException("Could not locate webp binary at " + Arrays.toString(sources));
    }

    protected static String[] getBinaryPath(String binaryName) {
        String os = "linux";
        if (SystemUtils.IS_OS_WINDOWS) {
            os = "window";
        } else if (SystemUtils.IS_OS_MAC) {
            os = "mac";
        }
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/" + os + "/" + binaryName, "/dist_webp_binaries/" + os + "/" + binaryName};
    }

    private static boolean setExecutable(Path output) throws IOException {
        try {
            return new ProcessBuilder("chmod", "+x", output.toAbsolutePath().toString()).start().waitFor(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

