/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.webp;

import com.sksamuel.scrimage.webp.WebpHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Gif2WebpHandler
extends WebpHandler {
    private static final Path binary;

    private static void installGif2Webp() throws IOException {
        Gif2WebpHandler.installBinary(binary, Gif2WebpHandler.getBinaryPath("gif2webp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(byte[] bytes, int m, int q, boolean lossy) throws IOException {
        Path input = Files.createTempFile("input", "gif", new FileAttribute[0]).toAbsolutePath();
        Path output = Files.createTempFile("to_webp", "webp", new FileAttribute[0]).toAbsolutePath();
        try {
            Files.write(input, bytes, StandardOpenOption.CREATE);
            this.convert(input, output, m, q, lossy);
            byte[] byArray = Files.readAllBytes(output);
            return byArray;
        }
        finally {
            try {
                input.toFile().delete();
            }
            catch (Exception exception) {}
            try {
                output.toFile().delete();
            }
            catch (Exception exception) {}
        }
    }

    public void convert(Path input, Path target, int m, int q, boolean lossy) throws IOException {
        Path stdout = Files.createTempFile("stdout", "webp", new FileAttribute[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binary.toAbsolutePath().toString());
        if (m >= 0) {
            commands.add("-m");
            commands.add(m + "");
        }
        if (q >= 0) {
            commands.add("-q");
            commands.add(q + "");
        }
        if (lossy) {
            commands.add("-lossy");
        }
        commands.add(input.toAbsolutePath().toString());
        commands.add("-o");
        commands.add(target.toAbsolutePath().toString());
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        builder.redirectOutput(stdout.toFile());
        Process process = builder.start();
        try {
            process.waitFor(5L, TimeUnit.MINUTES);
            int exitStatus = process.exitValue();
            if (exitStatus != 0) {
                List<String> error = Files.readAllLines(stdout);
                throw new IOException(error.toString());
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            process.destroy();
            stdout.toFile().delete();
        }
    }

    static {
        try {
            binary = Gif2WebpHandler.createPlaceholder("gif2webp");
            Gif2WebpHandler.installGif2Webp();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

