/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.webp;

import com.sksamuel.scrimage.webp.WebpHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DWebpHandler
extends WebpHandler {
    private static final Path binary;

    public static void installDWebp() throws IOException {
        DWebpHandler.installBinary(binary, DWebpHandler.getBinaryPaths("dwebp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(byte[] bytes) throws IOException {
        Path input = Files.createTempFile("input", "webp", new FileAttribute[0]).toAbsolutePath();
        Files.write(input, bytes, StandardOpenOption.CREATE);
        try {
            byte[] byArray = this.convert(input);
            return byArray;
        }
        finally {
            input.toFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(Path source) throws IOException {
        Path output = Files.createTempFile("from_webp", "png", new FileAttribute[0]).toAbsolutePath();
        try {
            this.convert(source, output);
            byte[] byArray = Files.readAllBytes(output);
            return byArray;
        }
        finally {
            output.toFile().delete();
        }
    }

    private void convert(Path input, Path target) throws IOException {
        Path stdout = Files.createTempFile("stdout", "webp", new FileAttribute[0]);
        ProcessBuilder builder = new ProcessBuilder(binary.toAbsolutePath().toString(), input.toAbsolutePath().toString(), "-o", target.toAbsolutePath().toString());
        builder.redirectErrorStream(true);
        builder.redirectOutput(stdout.toFile());
        Process process = builder.start();
        try {
            process.waitFor(5L, TimeUnit.MINUTES);
            int exitStatus = process.exitValue();
            if (exitStatus != 0) {
                List<String> error = Files.readAllLines(stdout);
                throw new IOException(error.toString());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            process.destroy();
            stdout.toFile().delete();
        }
    }

    static {
        try {
            Path pathFromProperty = DWebpHandler.getPathFromProperty("dwebp");
            if (pathFromProperty != null) {
                binary = pathFromProperty;
            } else {
                binary = DWebpHandler.createPlaceholder("dwebp");
                DWebpHandler.installDWebp();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

