/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.webp;

import com.sksamuel.scrimage.webp.WebpHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CWebpHandler
extends WebpHandler {
    private static final Path binary;

    public static void installCWebp() throws IOException {
        CWebpHandler.installBinary(binary, CWebpHandler.getBinaryPaths("cwebp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(byte[] bytes, int m, int q, int z, boolean lossless, boolean withoutAlpha, boolean multiThread) throws IOException {
        Path input = Files.createTempFile("input", "webp", new FileAttribute[0]).toAbsolutePath();
        Path output = Files.createTempFile("to_webp", "webp", new FileAttribute[0]).toAbsolutePath();
        try {
            Files.write(input, bytes, StandardOpenOption.CREATE);
            this.convert(input, output, m, q, z, lossless, withoutAlpha, multiThread);
            byte[] byArray = Files.readAllBytes(output);
            return byArray;
        }
        finally {
            try {
                input.toFile().delete();
            }
            catch (Exception exception) {}
            try {
                output.toFile().delete();
            }
            catch (Exception exception) {}
        }
    }

    private void convert(Path input, Path target, int m, int q, int z, boolean lossless, boolean withoutAlpha, boolean multiThread) throws IOException {
        Path stdout = Files.createTempFile("stdout", "webp", new FileAttribute[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binary.toAbsolutePath().toString());
        if (m >= 0) {
            commands.add("-m");
            commands.add(m + "");
        }
        if (q >= 0) {
            commands.add("-q");
            commands.add(q + "");
        }
        if (z >= 0) {
            commands.add("-z");
            commands.add(z + "");
        }
        if (lossless) {
            commands.add("-lossless");
        }
        if (withoutAlpha) {
            commands.add("-noalpha");
        }
        if (multiThread) {
            commands.add("-mt");
        }
        commands.add(input.toAbsolutePath().toString());
        commands.add("-o");
        commands.add(target.toAbsolutePath().toString());
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        builder.redirectOutput(stdout.toFile());
        Process process = builder.start();
        try {
            process.waitFor(5L, TimeUnit.MINUTES);
            int exitStatus = process.exitValue();
            if (exitStatus != 0) {
                List<String> error = Files.readAllLines(stdout);
                throw new IOException(error.toString());
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            process.destroy();
            stdout.toFile().delete();
        }
    }

    static {
        try {
            Path pathFromProperty = CWebpHandler.getPathFromProperty("cwebp");
            if (pathFromProperty != null) {
                binary = pathFromProperty;
            } else {
                binary = CWebpHandler.createPlaceholder("cwebp");
                CWebpHandler.installCWebp();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

