/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.webp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WebpHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebpHandler.class);

    WebpHandler() {
    }

    protected static Path getPathFromProperty(String name) {
        try {
            Path path;
            String binaryDir = System.getProperty("com.sksamuel.scrimage.webp.binary.dir");
            if (binaryDir != null && !binaryDir.isEmpty() && Files.isExecutable(path = Paths.get(binaryDir, name))) {
                return path;
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected static Path createPlaceholder(String name) throws IOException {
        return Files.createTempFile(name, "binary", new FileAttribute[0]);
    }

    protected static void installBinary(Path output, String ... sources) throws IOException {
        logger.info("Installing binary at {}", (Object)output);
        for (String source : sources) {
            logger.debug("Trying source from {}", (Object)source);
            InputStream in = WebpHandler.class.getResourceAsStream(source);
            if (in == null) continue;
            logger.debug("Source detected {}", (Object)source);
            Files.copy(in, output, StandardCopyOption.REPLACE_EXISTING);
            in.close();
            if (!SystemUtils.IS_OS_WINDOWS) {
                logger.info("Setting executable {}", (Object)output);
                WebpHandler.setExecutable(output);
            }
            return;
        }
        throw new IOException("Could not locate webp binary at " + Arrays.toString(sources));
    }

    protected static String[] getBinaryPaths(String binaryName) {
        String osArch = System.getProperty("os.arch");
        if (osArch == null) {
            osArch = "";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WebpHandler.windows(binaryName);
        }
        if ("mac_arm64".equals(System.getProperty("com.sksamuel.scrimage.webp.platform"))) {
            return WebpHandler.macArm(binaryName);
        }
        if (SystemUtils.IS_OS_MAC && (osArch.startsWith("arm") || osArch.startsWith("aarch64"))) {
            return WebpHandler.macArm(binaryName);
        }
        if (SystemUtils.IS_OS_MAC) {
            return WebpHandler.macIntel(binaryName);
        }
        if (SystemUtils.IS_OS_LINUX && (osArch.startsWith("arm") || osArch.startsWith("aarch64"))) {
            return WebpHandler.linuxArm(binaryName);
        }
        return WebpHandler.linux(binaryName);
    }

    private static String[] macIntel(String binaryName) {
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/mac/" + binaryName, "/dist_webp_binaries/libwebp-1.4.0-mac-x86-64/bin/" + binaryName};
    }

    private static String[] macArm(String binaryName) {
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/mac_arm64/" + binaryName, "/dist_webp_binaries/libwebp-1.4.0-mac-arm64/bin/" + binaryName};
    }

    private static String[] windows(String binaryName) {
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/" + binaryName + ".exe", "/webp_binaries/window/" + binaryName, "/webp_binaries/window/" + binaryName + ".exe", "/webp_binaries/windows/" + binaryName, "/webp_binaries/windows/" + binaryName + ".exe", "/dist_webp_binaries/libwebp-1.4.0-windows-x64/bin/" + binaryName, "/dist_webp_binaries/libwebp-1.4.0-windows-x64/bin/" + binaryName + ".exe"};
    }

    private static String[] linux(String binaryName) {
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/linux/" + binaryName, "/dist_webp_binaries/libwebp-1.4.0-linux-x86-64/bin/" + binaryName};
    }

    private static String[] linuxArm(String binaryName) {
        return new String[]{"/webp_binaries/" + binaryName, "/webp_binaries/linux/" + binaryName, "/dist_webp_binaries/libwebp-1.4.0-linux-aarch64/bin/" + binaryName};
    }

    private static void setExecutable(Path output) throws IOException {
        try {
            new ProcessBuilder("chmod", "+x", output.toAbsolutePath().toString()).start().waitFor(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

