package com.skyflow.sdk.api.exception.authentication;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when the bearer token is invalid.
 */
public class InvalidBearerTokenException extends SkyflowException {

    private final String token;

    public InvalidBearerTokenException() {
        this(null);
    }

    /**
     * Default constructor. Sets the default message.
     */
    public InvalidBearerTokenException(String token) {
        this(token, "Bearer token cannot be null or blank.");
    }

    /**
     * Constructor that sets the message and the gRPC code of the exception.
     *
     * @param message The message of the error.
     */
    public InvalidBearerTokenException(String token, String message) {
        super(message);
        this.token = token;
    }

    public String getToken() {
        return token;
    }
}
