package com.skyflow.sdk.api.exception.http;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when a 500 error is returned from the Skyflow API.
 */
public class InternalServerErrorException extends SkyflowException {
    private final Integer grpcCode;

    /**
     * Default constructor. Sets the message and the gRPC code of the exception.
     *
     * @param message  The message of the error.
     * @param grpcCode The GRPC code of the error.
     */
    public InternalServerErrorException(Integer grpcCode, String message) {
        super(message);
        this.grpcCode = grpcCode;
    }

    public Integer getGrpcCode() {
        return grpcCode;
    }
}
