package com.skyflow.sdk.api.exception.validation;

/**
 * Exceptions related to the invalid expiration time set for JWT token authentication.
 */
public class InvalidExpirationTimeException extends ValidationException {

    public InvalidExpirationTimeException() {
        super("Expiration time cannot be null and must be a future time.");
    }

    public InvalidExpirationTimeException(Throwable cause) {
        super(cause);
    }
}