package com.skyflow.sdk.api.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Interface to wrap the Skyflow API request to be sent via the wrapped @{@link HttpClient HTTP client}.
 */
public interface HttpRequest {
    String AUTHORIZATION_HEADER = "Authorization";
    String X_SKYFLOW_AUTHORIZATION = "X-Skyflow-Authorization";

    /**
     * Retrieves request method name to invoke Skyflow API endpoint, e.g. GET, POST, PUT.
     *
     * @return HttpMethod The method name.
     */
    HttpMethod getMethod();

    /**
     * Retrieves request url.
     *
     * @return String the URL.
     */
    String getUrl();

    /**
     * Retrieves request query parameters map.
     *
     * @return Map The query params.
     */
    Map<String, List<String>> getQueryParams();

    /**
     * Retrieves request headers map.
     *
     * @return Map The headers.
     */
    Map<String, List<String>> getHeaders();

    /**
     * Retrieves request body input stream.
     *
     * @return InputStream The body
     */
    InputStream getBody();
}
