package com.skyflow.sdk.api.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Interface to wrap the Skyflow API response object retrieved from the wrapped @{@link HttpClient HTTP client} request invocation.
 */
public interface HttpResponse {

    /**
     * Retrieves response headers map.
     *
     * @return Map The headers.
     */
    Map<String, List<String>> getHeaders();

    /**
     * Retrieves response body input stream.
     *
     * @return InputStream The body.
     */
    InputStream getBody();

    /**
     * Retrieves response status number.
     *
     * @return int The status code.
     */
    int getStatusCode();
}
