package com.skyflow.sdk.internal.http;

import com.skyflow.sdk.api.http.HttpClient;
import com.skyflow.sdk.api.http.HttpMethod;
import com.skyflow.sdk.api.http.HttpRequest;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

import static java.util.Collections.unmodifiableMap;

/**
 * Interface to wrap the Skyflow API request to be sent via the wrapped @{@link HttpClient HTTP client}.
 */
public class SimpleHttpRequest implements HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> queryParams;
    private final Map<String, List<String>> headers;
    private final InputStream body;

    SimpleHttpRequest(HttpMethod method, String url, Map<String, List<String>> queryParams, Map<String, List<String>> headers, InputStream body) {
        this.method = method;
        this.url = url;
        this.queryParams = unmodifiableMap(queryParams);
        this.headers = unmodifiableMap(headers);
        this.body = body;
    }

    /**
     * Retrieves request method name to invoke Skyflow API endpoint, e.g. GET, POST, PUT.
     */
    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    /**
     * Retrieves request url.
     */
    @Override
    public String getUrl() {
        return this.url;
    }

    /**
     * Retrieves request query parameters map.
     */
    @Override
    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    /**
     * Retrieves request headers map.
     */
    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    /**
     * Retrieves request body input stream.
     */
    @Override
    public InputStream getBody() {
        return this.body;
    }

    @Override
    public String toString() {
        return "SimpleHttpRequest{" +
                "method=" + method +
                ", url='" + url + '\'' +
                ", queryParams=" + queryParams +
                ", headers=" + headers +
                ", body=" + body +
                '}';
    }
}
