package com.skyflow.sdk.internal.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JwtCredentials {

    @JsonProperty("clientID")
    private String clientId;

    @JsonProperty("keyID")
    private String apiKey;

    private String privateKey;

    public JwtCredentials() {
    }

    public JwtCredentials(String clientId, String apiKey, String privateKey) {
        this.clientId = clientId;
        this.apiKey = apiKey;
        this.privateKey = privateKey;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }
}
