/*
 * Decompiled with CFR 0.152.
 */
package com.skyflow.sdk.internal.http;

import com.skyflow.sdk.api.http.HttpMethod;
import com.skyflow.sdk.api.http.HttpRequest;
import com.skyflow.sdk.internal.http.SimpleHttpRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class HttpRequestBuilder {
    private final HttpMethod method;
    private final String url;
    private final Map<String, String> pathParams = new HashMap<String, String>();
    private final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream body;

    public HttpRequestBuilder(HttpMethod method, String url) {
        this.method = method;
        this.url = url;
    }

    public HttpRequestBuilder withPathParam(String key, String value) {
        this.pathParams.put(key, value);
        return this;
    }

    public HttpRequestBuilder withQueryParams(String key, String ... values) {
        return this.appendToMap(this.queryParams, key, values);
    }

    public HttpRequestBuilder withQueryParams(Map<String, List<String>> queryParams) {
        return this.appendToMap(this.queryParams, queryParams);
    }

    public HttpRequestBuilder withJSonContentType() {
        return this.withHeaders("Content-Type", "application/json");
    }

    public HttpRequestBuilder withAuthorization(String token) {
        return this.withHeaders("Authorization", token);
    }

    public HttpRequestBuilder withAuthorizationBearer(String token) {
        return this.withHeaders("Authorization", String.format("Bearer %s", token));
    }

    public HttpRequestBuilder withHeaders(String key, String ... values) {
        return this.appendToMap(this.headers, key, values);
    }

    public HttpRequestBuilder withHeaders(Map<String, List<String>> headers) {
        return this.appendToMap(this.headers, headers);
    }

    public HttpRequestBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public HttpRequestBuilder withBody(String body) {
        this.body = IOUtils.toInputStream((String)body, (Charset)Charset.defaultCharset());
        return this;
    }

    private HttpRequestBuilder appendToMap(Map<String, List<String>> map, String key, String ... values) {
        map.computeIfAbsent(key, element -> new ArrayList()).addAll(Stream.of(values).collect(Collectors.toList()));
        return this;
    }

    private HttpRequestBuilder appendToMap(Map<String, List<String>> map, Map<String, List<String>> newValues) {
        Optional.ofNullable(newValues).ifPresent(map::putAll);
        return this;
    }

    public HttpRequest build() {
        String computedUrl = this.url;
        for (Map.Entry<String, String> pathParam : this.pathParams.entrySet()) {
            computedUrl = computedUrl.replaceAll(String.format("\\{%s\\}", pathParam.getKey()), pathParam.getValue());
        }
        return new SimpleHttpRequest(this.method, computedUrl, this.queryParams, this.headers, this.body);
    }
}

