/*
 * Decompiled with CFR 0.152.
 */
package com.skyflow.sdk.internal.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.skyflow.sdk.api.exception.authentication.InvalidBearerTokenException;
import com.skyflow.sdk.api.exception.authentication.JWTAuthenticationException;
import com.skyflow.sdk.api.exception.parse.ParsingException;
import com.skyflow.sdk.api.exception.validation.InvalidApiKeyException;
import com.skyflow.sdk.api.exception.validation.InvalidClientIdException;
import com.skyflow.sdk.api.exception.validation.InvalidConnectionIdValidationException;
import com.skyflow.sdk.api.exception.validation.InvalidCredentialsFileException;
import com.skyflow.sdk.api.exception.validation.InvalidExpirationTimeException;
import com.skyflow.sdk.api.exception.validation.InvalidJWTException;
import com.skyflow.sdk.api.exception.validation.InvalidPrivateKeyException;
import com.skyflow.sdk.api.http.HttpClient;
import com.skyflow.sdk.api.http.HttpMethod;
import com.skyflow.sdk.api.model.AuthKey;
import com.skyflow.sdk.api.model.Route;
import com.skyflow.sdk.api.service.ManagementService;
import com.skyflow.sdk.internal.http.HttpRequestBuilder;
import com.skyflow.sdk.internal.model.GetAuthKeysResponse;
import com.skyflow.sdk.internal.model.JwtCredentials;
import com.skyflow.sdk.internal.model.RoutesResponse;
import com.skyflow.sdk.internal.service.SkyflowService;
import com.skyflow.sdk.internal.utils.Validator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServiceImpl
extends SkyflowService
implements ManagementService {
    private static final Logger logger = LoggerFactory.getLogger(ManagementServiceImpl.class);
    private static final String TOKEN_URI = "https://manage.skyflowapis.com/v1/auth/sa/oauth/token";

    public ManagementServiceImpl(HttpClient client, ObjectMapper objectMapper) {
        super(client, objectMapper);
    }

    @Override
    public String getBearerToken(Path credentialsFilePath, Instant expirationTime) throws IOException, TimeoutException {
        JwtCredentials jwtCredentials;
        logger.debug("Validating that the credentials file path represents a file that actually exists and can be read.");
        Validator.validateExistingFile(credentialsFilePath, InvalidCredentialsFileException::new);
        try (FileInputStream credentialsStream = new FileInputStream(credentialsFilePath.toFile());){
            jwtCredentials = this.unmarshall(credentialsStream, JwtCredentials.class);
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
        return this.getBearerToken(jwtCredentials.getClientId(), jwtCredentials.getApiKey(), jwtCredentials.getPrivateKey(), expirationTime, new String[0]);
    }

    @Override
    public String getBearerToken(String clientId, String apiKey, String privateKey, Instant expirationTime, String ... tokenURI) throws IOException, TimeoutException {
        try {
            logger.debug("Validating client ID for emptiness.");
            Validator.validateNotEmpty(clientId, InvalidClientIdException::new);
            logger.debug("Validating API key for emptiness.");
            Validator.validateNotEmpty(apiKey, InvalidApiKeyException::new);
            logger.debug("Validating private key for emptiness.");
            Validator.validateNotEmpty(privateKey, InvalidPrivateKeyException::new);
            logger.debug("Validating that expiration time is in the future.");
            Validator.validateFutureDate(expirationTime, InvalidExpirationTimeException::new);
            logger.info("Retrieving bearer token.");
            String tokenURL = tokenURI.length > 0 ? tokenURI[0] : TOKEN_URI;
            return Optional.ofNullable(this.send(new HttpRequestBuilder(HttpMethod.POST, tokenURL).withAuthorization(apiKey.trim()).withJSonContentType().withBody(String.format("{\"grant_type\": \"urn:ietf:params:oauth:grant-type:jwt-bearer\", \"assertion\": \"%s\"}", JWT.create().withClaim("iss", clientId.trim()).withClaim("key", apiKey.trim()).withClaim("aud", tokenURL).withClaim("exp", Long.valueOf(expirationTime.getEpochSecond())).withClaim("sub", clientId.trim()).sign(Algorithm.RSA256(null, (RSAPrivateKey)((RSAPrivateKey)RSAPrivateKey.class.cast(KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Optional.of(new PemReader((Reader)new StringReader(privateKey.trim()))).map(pemReader -> {
                try {
                    return pemReader.readPemObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).map(PemObject::getContent).orElseThrow(InvalidPrivateKeyException::new))))))))).build())).map(this::unmarshall).map(tree -> tree.get("accessToken")).map(JsonNode::textValue).orElseThrow(ParsingException::new);
        }
        catch (InvalidBearerTokenException e) {
            switch (e.getMessage().toLowerCase()) {
                case "error: invalid key": 
                case "error: crypto/rsa: verification error": {
                    throw new InvalidJWTException(e);
                }
                case "error: invalid_grant: invalid exp": {
                    throw new InvalidExpirationTimeException(e);
                }
            }
            throw e;
        }
        catch (InvalidKeySpecException e) {
            throw new JWTAuthenticationException("Invalid private key specification.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JWTAuthenticationException("No provider found for RSA algorithm.", e);
        }
    }

    @Override
    public List<AuthKey> getAuthKeys(String bearerToken) throws IOException, TimeoutException {
        logger.debug("Validating bearer token for emptiness.");
        Validator.validateNotEmpty(bearerToken, InvalidBearerTokenException::new);
        logger.info("Retrieving auth keys.");
        return this.unmarshall(this.send(new HttpRequestBuilder(HttpMethod.GET, "https://manage.skyflowapis.com/v1/auth/sa/oauth/keys").withAuthorizationBearer(bearerToken.trim()).build()), GetAuthKeysResponse.class).getKeys();
    }

    @Override
    public List<Route> getRoutes(String bearerToken, String connectionId) throws IOException, TimeoutException {
        logger.debug("Validating bearer token for emptiness.");
        Validator.validateNotEmpty(bearerToken, InvalidBearerTokenException::new);
        logger.debug("Validating connection ID for emptiness.");
        String normalizedConectionId = connectionId;
        if (normalizedConectionId != null && !normalizedConectionId.isEmpty() && (normalizedConectionId = normalizedConectionId.trim()).startsWith("/")) {
            normalizedConectionId = normalizedConectionId.substring(1);
        }
        Validator.validateNotEmpty(normalizedConectionId, InvalidConnectionIdValidationException::new);
        logger.info("Retrieving routes.");
        return this.unmarshall(this.send(new HttpRequestBuilder(HttpMethod.GET, "https://manage.skyflowapis.com/v1/gateway/outboundRoutes/{connectionId}").withAuthorizationBearer(bearerToken.trim()).withJSonContentType().withPathParam("connectionId", normalizedConectionId).build()), RoutesResponse.class).getRoutes();
    }
}

