package com.skyflow.sdk.api.exception.parse;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when an error occurs while parsing.
 *
 * @author sriv
 */
public class ParsingException extends SkyflowException {
    private static final String MESSAGE = "An error occurred while parsing.";

    /**
     * Default constructor. Adds it's own message.
     */
    public ParsingException() {
        super(MESSAGE);
    }

    /**
     * Constructor that appends the exception's custom message to the cause.
     *
     * @param cause The root cause of the exception.
     */
    public ParsingException(Throwable cause) {
        super(MESSAGE, cause);
    }
}
