package com.skyflow.sdk.api.exception.validation;

/**
 * Exceptions related to the invalid expiration time set for JWT token authentication.
 *
 * @author sriv
 */
public class InvalidExpirationTimeException extends ValidationException {

    /**
     * <p>Constructor for InvalidExpirationTimeException.</p>
     */
    public InvalidExpirationTimeException() {
        super("Expiration time cannot be null and must be a future time.");
    }

    /**
     * <p>Constructor for InvalidExpirationTimeException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object
     */
    public InvalidExpirationTimeException(Throwable cause) {
        super(cause);
    }
}
