package com.skyflow.sdk.api.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Interface to wrap the Skyflow API request to be sent via the wrapped @{@link HttpClient HTTP client}.
 *
 * @author sriv
 */
public interface HttpRequest {
    /** Constant <code>AUTHORIZATION_HEADER="Authorization"</code> */
    String AUTHORIZATION_HEADER = "Authorization";
    /** Constant <code>X_SKYFLOW_AUTHORIZATION="X-Skyflow-Authorization"</code> */
    String X_SKYFLOW_AUTHORIZATION = "X-Skyflow-Authorization";

    /**
     * Retrieves request method name to invoke Skyflow API endpoint, e.g. GET, POST, PUT.
     *
     * @return a {@link com.skyflow.sdk.api.http.HttpMethod} object
     */
    HttpMethod getMethod();

    /**
     * Retrieves request url.
     *
     * @return a {@link java.lang.String} object
     */
    String getUrl();

    /**
     * Retrieves request query parameters map.
     *
     * @return a {@link java.util.Map} object
     */
    Map<String, List<String>> getQueryParams();

    /**
     * Retrieves request headers map.
     *
     * @return a {@link java.util.Map} object
     */
    Map<String, List<String>> getHeaders();

    /**
     * Retrieves request body input stream.
     *
     * @return a {@link java.io.InputStream} object
     */
    InputStream getBody();
}
