package com.skyflow.sdk.api.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Interface to wrap the Skyflow API response object retrieved from the wrapped @{@link HttpClient HTTP client} request invocation.
 *
 * @author sriv
 */
public interface HttpResponse {

    /**
     * Retrieves response headers map.
     *
     * @return a {@link java.util.Map} object
     */
    Map<String, List<String>> getHeaders();

    /**
     * Retrieves response body input stream.
     *
     * @return a {@link java.io.InputStream} object
     */
    InputStream getBody();

    /**
     * Retrieves response status number.
     *
     * @return a int
     */
    int getStatusCode();
}
