package com.skyflow.sdk.internal.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * <p>JwtCredentials class.</p>
 *
 * @author sriv
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JwtCredentials {

    @JsonProperty("clientID")
    private String clientId;

    @JsonProperty("keyID")
    private String apiKey;

    private String tokenURI;

    /**
     * <p>Constructor for JwtCredentials.</p>
     */
    private String privateKey;

    public JwtCredentials() {
    }

    /**
     * <p>Constructor for JwtCredentials.</p>
     *
     * @param clientId a {@link java.lang.String} object
     * @param apiKey a {@link java.lang.String} object
     * @param privateKey a {@link java.lang.String} object
     */
    public JwtCredentials(String clientId, String apiKey, String privateKey) {
        this.clientId = clientId;
        this.apiKey = apiKey;
        this.privateKey = privateKey;
    }

    /**
     * <p>Constructor for JwtCredentials.</p>
     *
     * @param clientId a {@link java.lang.String} object
     * @param apiKey a {@link java.lang.String} object
     * @param privateKey a {@link java.lang.String} object
     * @param tokenURI a {@link java.lang.String} object
     * @since 1.2.0
     */
    public JwtCredentials(String clientId, String apiKey, String privateKey, String tokenURI) {
        this.clientId = clientId;
        this.apiKey = apiKey;
        this.privateKey = privateKey;
        this.tokenURI = tokenURI;
    }


    /**
     * <p>Getter for the field <code>clientId</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getClientId() {
        return clientId;
    }

    /**
     * <p>Setter for the field <code>clientId</code>.</p>
     *
     * @param clientId a {@link java.lang.String} object
     */
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * <p>Getter for the field <code>apiKey</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getApiKey() {
        return apiKey;
    }

    /**
     * <p>Setter for the field <code>apiKey</code>.</p>
     *
     * @param apiKey a {@link java.lang.String} object
     */
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    /**
     * <p>Getter for the field <code>privateKey</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * <p>Setter for the field <code>privateKey</code>.</p>
     *
     * @param privateKey a {@link java.lang.String} object
     */
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * <p>Getter for the field <code>tokenURI</code>.</p>
     *
     * @return a {@link java.lang.String} object
     * @since 1.2.0
     */
    public String getTokenURI() {
        return tokenURI;
    }

    /**
     * <p>Setter for the field <code>tokenURI</code>.</p>
     *
     * @param tokenURI a {@link java.lang.String} object
     * @since 1.2.0
     */
    public void setTokenURI(String tokenURI) {
        this.tokenURI = tokenURI;
    }
}
