package com.skyflow.sdk.api.exception;

/**
 * Parent class of all exceptions thrown by the SDK.
 *
 * @author sriv
 */
public class SkyflowException extends RuntimeException {

    /**
     * <p>Constructor for SkyflowException.</p>
     *
     * @see Exception#Exception(String)
     * @param message String
     */
    public SkyflowException(String message) {
        super(message);
    }

    /**
     * <p>Constructor for SkyflowException.</p>
     *
     * @see Exception#Exception(Throwable)
     * @param cause Throwable
     */
    public SkyflowException(Throwable cause) {
        super(cause);
    }

    /**
     * <p>Constructor for SkyflowException.</p>
     *
     * @see Exception#Exception(String, Throwable)
     * @param message String
     * @param cause Throwable
     */
    public SkyflowException(String message, Throwable cause) {
        super(message, cause);
    }

}
