package com.skyflow.sdk.api.exception.authentication;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when the bearer token is invalid.
 *
 * @author sriv
 */
public class InvalidBearerTokenException extends SkyflowException {

    /**
     * token String
     */
    private final String token;

    /**
     * <p>Constructor for InvalidBearerTokenException.</p>
     */
    public InvalidBearerTokenException() {
        this(null);
    }

    /**
     * Default constructor. Sets the default message.
     *
     * @param token a {@link java.lang.String} object
     */
    public InvalidBearerTokenException(String token) {
        this(token, "Bearer token cannot be null or blank.");
    }

    /**
     * Constructor that sets the message and the gRPC code of the exception.
     *
     * @param message The message of the error.
     * @param token a {@link java.lang.String} object
     */
    public InvalidBearerTokenException(String token, String message) {
        super(message);
        this.token = token;
    }

    /**
     * <p>Getter for the field <code>token</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getToken() {
        return token;
    }
}
