package com.skyflow.sdk.api.exception.http;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when a 400 error is returned from the Skyflow API.
 *
 * @author sriv
 */
public class NotFoundException extends SkyflowException {
    /**
     * grpcCode Integer
     */
    private final Integer grpcCode;

    /**
     * Default constructor. Sets the message and the gRPC code of the exception.
     *
     * @param message  The message of the error.
     * @param grpcCode The GRPC code of the error.
     */
    public NotFoundException(Integer grpcCode, String message) {
        super(message);
        this.grpcCode = grpcCode;
    }

    /**
     * <p>Getter for the field <code>grpcCode</code>.</p>
     *
     * @return a {@link java.lang.Integer} object
     */
    public Integer getGrpcCode() {
        return grpcCode;
    }
}
