package com.skyflow.sdk.api.exception.validation;

import com.skyflow.sdk.api.exception.SkyflowException;

/**
 * Exception thrown when a validation error occurs.
 *
 * @author sriv
 */
public class ValidationException extends SkyflowException {

    /**
     * <p>Constructor for ValidationException.</p>
     *
     * @see Exception#Exception(String)
     * @param message a {@link java.lang.String} object
     */
    public ValidationException(String message) {
        super(message);
    }

    /**
     * <p>Constructor for ValidationException.</p>
     *
     * @see Exception#Exception(Throwable)
     * @param cause a {@link java.lang.Throwable} object
     */
    public ValidationException(Throwable cause) {
        super(cause);
    }

    /**
     * <p>Constructor for ValidationException.</p>
     *
     * @see Exception#Exception(String, Throwable)
     * @param message a {@link java.lang.String} object
     * @param cause a {@link java.lang.Throwable} object
     */
    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }
}
