package com.skyflow.sdk.api.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

/**
 * Interface to setup a HTTP client on the Skyflow API which builds and executes client requests.
 *
 * @author sriv
 */
public interface HttpClient extends Closeable {

    /**
     * Sends requests to Skyflow API based on the wrapped @{@link HttpRequest request} and receives a wrapped @{@link HttpResponse response} back.
     *
     * @param request wrapped client request
     * @return wrapped Skyflow API response
     * @throws java.util.concurrent.TimeoutException if any.
     * @throws java.io.IOException if any.
     */
    HttpResponse send(HttpRequest request) throws TimeoutException, IOException;
}
