package com.skyflow.sdk.api.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/**
 * Default interface that allows access to the Skyflow Gateway API.
 *
 * @author sriv
 */
public interface GatewayService {

    /**
     * Tokenizes a single or bulk group of fields identified in a particular connection by invoking the Skyflow Gateway.
     *
     * @param bearerToken  The authorization token.
     * @param connectionId The ID of the connection to use.
     * @param relativePath a {@link java.lang.String} object
     * @param fields       A {@link java.util.Map} of fields with its values.
     * @return Map A {@link java.util.Map} containing the name of the tokenized fields as key and the token as value.
     * @throws java.io.IOException if any.
     * @throws java.util.concurrent.TimeoutException if any.
     */
    Map<String, Object> tokenize(String bearerToken,
                                 String connectionId,
                                 String relativePath,
                                 Map<String, Object> fields) throws IOException, TimeoutException;

    /**
     * Detokenizes a single or bulk group of fields identified in a particular connection by invoking the Skyflow Gateway.
     *
     * @param bearerToken  The authorization token.
     * @param connectionId The ID of the connection to use.
     * @param relativePath a {@link java.lang.String} object
     * @param fields       A {@link java.util.Map} of fields with its values.
     * @return Map A {@link java.util.Map} containing the name of the tokenized fields as key and the token as value.
     * @throws java.io.IOException if any.
     * @throws java.util.concurrent.TimeoutException if any.
     */
    Map<String, Object> detokenize(String bearerToken,
                                   String connectionId,
                                   String relativePath,
                                   Map<String, Object> fields) throws IOException, TimeoutException;
}
