package com.skyflow.sdk.internal.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

/**
 * <p>SkyflowError class.</p>
 *
 * @author sriv
 */
@JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
@JsonTypeName(value = "error")
public class SkyflowError {

    @JsonProperty
    private String message;

    @JsonProperty("grpc_code")
    private Integer grpcCode;

    @JsonProperty("http_code")
    private Integer httpCode;

    @JsonProperty("http_status")
    private String httpStatus;

    private List<String> details;

    /**
     * <p>Getter for the field <code>message</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getMessage() {
        return message;
    }

    /**
     * <p>Setter for the field <code>message</code>.</p>
     *
     * @param message a {@link java.lang.String} object
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>Getter for the field <code>grpcCode</code>.</p>
     *
     * @return a {@link java.lang.Integer} object
     */
    public Integer getGrpcCode() {
        return grpcCode;
    }

    /**
     * <p>Setter for the field <code>grpcCode</code>.</p>
     *
     * @param grpcCode a {@link java.lang.Integer} object
     */
    public void setGrpcCode(Integer grpcCode) {
        this.grpcCode = grpcCode;
    }

    /**
     * <p>Getter for the field <code>httpCode</code>.</p>
     *
     * @return a {@link java.lang.Integer} object
     */
    public Integer getHttpCode() {
        return httpCode;
    }

    /**
     * <p>Setter for the field <code>httpCode</code>.</p>
     *
     * @param httpCode a {@link java.lang.Integer} object
     */
    public void setHttpCode(Integer httpCode) {
        this.httpCode = httpCode;
    }

    /**
     * <p>Getter for the field <code>httpStatus</code>.</p>
     *
     * @return a {@link java.lang.String} object
     */
    public String getHttpStatus() {
        return httpStatus;
    }

    /**
     * <p>Setter for the field <code>httpStatus</code>.</p>
     *
     * @param httpStatus a {@link java.lang.String} object
     */
    public void setHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
    }

    /**
     * <p>Getter for the field <code>details</code>.</p>
     *
     * @return a {@link java.util.List} object
     */
    public List<String> getDetails() {
        return details;
    }

    /**
     * <p>Setter for the field <code>details</code>.</p>
     *
     * @param details a {@link java.util.List} object
     */
    public void setDetails(List<String> details) {
        this.details = details;
    }
}
