/*
 * Decompiled with CFR 0.152.
 */
package com.skyflow.sdk.internal.utils;

import com.skyflow.sdk.api.exception.SkyflowException;
import com.skyflow.sdk.api.exception.validation.ValidationException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Validator {
    private Validator() {
        throw new UnsupportedOperationException();
    }

    public static void validateNotEmpty(String value, Supplier<? extends SkyflowException> exceptionSupplier) {
        Optional.ofNullable(value).map(String::trim).filter(Predicate.isEqual("").negate()).orElseThrow(exceptionSupplier);
    }

    public static void validateNotEmpty(Map value, Supplier<? extends SkyflowException> exceptionSupplier) {
        Optional.ofNullable(value).filter(v -> !v.isEmpty()).orElseThrow(exceptionSupplier);
    }

    public static void validateFutureDate(Instant value, Supplier<? extends ValidationException> exceptionSupplier) {
        Optional.ofNullable(value).filter(exp -> exp.isAfter(Instant.now())).orElseThrow(exceptionSupplier);
    }

    public static void validateExistingFile(Path path, Supplier<? extends SkyflowException> exceptionSupplier) {
        Optional.ofNullable(path).map(Path::toFile).filter(File::exists).filter(File::isFile).filter(File::canRead).orElseThrow(exceptionSupplier);
    }

    public static void validateUrl(String url, Supplier<? extends SkyflowException> exceptionSupplier) {
        Optional.ofNullable(url).map(String::trim).filter(Predicate.isEqual("").negate()).map(u -> {
            try {
                return new URI((String)u);
            }
            catch (URISyntaxException e) {
                throw (SkyflowException)exceptionSupplier.get();
            }
        }).filter(URI::isAbsolute).orElseThrow(exceptionSupplier);
    }
}

