/*
 * Decompiled with CFR 0.152.
 */
package com.skyflow.sdk.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.skyflow.sdk.api.exception.authentication.InvalidBearerTokenException;
import com.skyflow.sdk.api.exception.http.InvalidConnectionIdException;
import com.skyflow.sdk.api.exception.http.NotFoundException;
import com.skyflow.sdk.api.exception.validation.InvalidBaseUrlException;
import com.skyflow.sdk.api.exception.validation.InvalidConnectionIdValidationException;
import com.skyflow.sdk.api.exception.validation.InvalidFieldsException;
import com.skyflow.sdk.api.exception.validation.InvalidRelativePathException;
import com.skyflow.sdk.api.http.HttpClient;
import com.skyflow.sdk.api.http.HttpMethod;
import com.skyflow.sdk.api.service.GatewayService;
import com.skyflow.sdk.internal.http.HttpRequestBuilder;
import com.skyflow.sdk.internal.service.SkyflowService;
import com.skyflow.sdk.internal.utils.Validator;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayServiceImpl
extends SkyflowService
implements GatewayService {
    private static final Logger logger = LoggerFactory.getLogger(GatewayServiceImpl.class);
    private final String baseUrl;

    public GatewayServiceImpl(String baseUrl, HttpClient client, ObjectMapper objectMapper) {
        super(client, objectMapper);
        this.baseUrl = this.normalizePathPart(baseUrl);
        Validator.validateUrl(this.baseUrl, InvalidBaseUrlException::new);
    }

    @Override
    public Map<String, Object> tokenize(String bearerToken, String connectionId, String relativePath, Map<String, Object> fields) throws IOException, TimeoutException {
        logger.info("Applying tokenization");
        return this.sendGatewayRequest(bearerToken, connectionId, relativePath, fields);
    }

    @Override
    public Map<String, Object> detokenize(String bearerToken, String connectionId, String relativePath, Map<String, Object> fields) throws IOException, TimeoutException {
        logger.info("Applying detokenization");
        return this.sendGatewayRequest(bearerToken, connectionId, relativePath, fields);
    }

    private Map<String, Object> sendGatewayRequest(String bearerToken, String connectionId, String relativePath, Map<String, Object> fields) throws IOException, TimeoutException {
        logger.debug("Validating bearer token for emptiness.");
        Validator.validateNotEmpty(bearerToken, InvalidBearerTokenException::new);
        logger.debug("Validating connection ID for emptiness.");
        Validator.validateNotEmpty(this.normalizePathPart(connectionId), InvalidConnectionIdValidationException::new);
        logger.debug("Validating relative path for emptiness.");
        Validator.validateNotEmpty(relativePath, InvalidRelativePathException::new);
        String url = String.format("%s/v1/gateway/inboundRoutes/%s/%s", this.baseUrl, this.normalizePathPart(connectionId), this.normalizePathPart(relativePath));
        logger.debug("Validating full URL.");
        Validator.validateUrl(url, InvalidRelativePathException::new);
        logger.debug("Validating fields map for emptiness.");
        Validator.validateNotEmpty(fields, InvalidFieldsException::new);
        try {
            return this.unmarshall(this.send(new HttpRequestBuilder(HttpMethod.POST, url).withHeaders("X-Skyflow-Authorization", bearerToken.trim()).withJSonContentType().withBody(this.marshall(fields)).build()), Map.class);
        }
        catch (NotFoundException e) {
            Optional.of(e.getMessage()).filter(s -> s.contains("Error Reading Document")).ifPresent(s -> {
                throw new InvalidConnectionIdException("Invalid connection id", e);
            });
            throw e;
        }
    }

    private String normalizePathPart(String path) {
        if (path != null && !path.isEmpty()) {
            if ((path = path.trim()).startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }
}

